@extends('default.admin.layouts.master')

@section('style')
    {!! Html::style('css/styles.css') !!}
@endsection

@section('content')

    <div class="container-fluid min_height_area">
        <div class="row">
            <div class="col-md-12">
                <div class="student-box-header">
                    <div class="col-md-6 col-xs-6">
                        <span class="glyphicon glyphicon-user "
                              aria-hidden="true"></span>{{ trans('sidebar.class_timing_list') }}
                    </div>
                    <div class="col-md-6 col-xs-6 snt">
                        {{--<ul class="breadcrumb text-right">
                            <li>
                                <a href="{!! route('class-timing-create-form') !!}"><i
                                            class="fa fa-plus"></i> {{ trans('sidebar.create_class_timing') }}</a>
                            </li>
                        </ul>--}}
                    </div>
                </div>
            </div>
        </div> <!--row-->
        <div class="row">
            <div class="col-md-12">
                <div class="view-header">
                    <button onclick="javascript:window.print()" class="btn btn-primary"><span
                                class="fa fa-print"></span> {{ trans('translate.print') }} </button>
                    <button onclick="javascript:window.print()" class="btn btn-primary"><span
                                class="fa fa-file"></span> {{ trans('translate.print_preview') }} </button>
                    <button class="btn btn-primary"><span class="fa fa-file"></span> {{ trans('translate.edit') }}
                    </button>

                </div>
            </div>


            @if(session()->has('success'))
                <div class="col-md-8 col-md-offset-2 text-center">
                    <div class="alert alert-success successOrErrorMsgDiv">
                        <p>{{session()->get('success')}}</p>
                    </div>
                </div>
            @endif
            @if(session()->has('error'))
                <div class="col-md-8 col-md-offset-2 text-center">
                    <div class="alert alert-danger successOrErrorMsgDiv">
                        <p class="">{{session()->get('error')}}</p>
                    </div>
                </div>
            @endif
            @if ($errors->any())
                <div class="col-md-8 col-md-offset-2 text-capitalize">
                    <div class="alert alert-warning successOrErrorMsgDiv">
                        @foreach ($errors->all() as $error)
                            <p>{{ $error }}</p>
                        @endforeach
                    </div>
                </div>
            @endif

            <div class="col-xs-12 col-sm-12 col-md-12">
                <div class="col-xs-12 col-sm-6 col-md-3" style="background-color: #3c8dbc; color:white; text-align: center; border-top-left-radius:5px; border-top-right-radius:5px;">
                    {{date('d F o', strtotime($theTimetable->start_date)) }}
                    <i class="fa fa-arrow-right"></i>
                    {{date('d F o', strtotime($theTimetable->end_date))}}
                    <input type="hidden" id="timetable_id" value="{{$theTimetable->id}}">
                </div>
            </div>


        </div> <!--row-->


        <div class="inner-box">
            <div class="row">
                <div id="datatable">
                    <div class="row last">
                        <div class="col-sm-12 col-xs-12">
                            <div class="box">
                                <div class="box-body auto_scroll">

                                    <table id="example1" class="table table-bordered table-striped table-responsive">

                                        <thead>
                                      {{--  <tr>
                                            <th colspan="4">

                                                {{date('d F o', strtotime($theTimetable->start_date)) }}
                                                <i class="fa fa-arrow-right"></i>
                                                {{date('d F o', strtotime($theTimetable->end_date))}}

                                            </th>
                                        </tr>--}}
                                        <tr>
                                            <th>{{ trans('translate.sl') }}</th>
                                            <th>Class</th>
                                            <th>Section</th>
                                            <th>{{ trans('translate.status') }}</th>
                                        </tr>
                                        </thead>
                                        <tbody>

                                        @foreach($sectionList as $key=>$section)
                                            <tr>
                                                <td>{{ $key+1 }}</td>
                                                <td>{{ $section->studentClass->class_name ?? 'Not Found'}}</td>
                                                <td>
                                                    <input title="" type="checkbox" class="section_cb" value="{{$section->id}}"
                                                           @if(count($sectionIds)>0)
                                                           @foreach($sectionIds as $k=>$sectionId)
                                                           @if($sectionId==$section->id)
                                                           checked="checked" disabled
                                                            @endif
                                                            @endforeach
                                                            @endif
                                                    >
                                                    {{ $section->section_name ?? 'Not Found'}}
                                                </td>
                                                <td>{{getActiveInactive($section->status)}}</td>

                                            </tr>
                                        @endforeach
                                        </tbody>
                                        <tfoot>
                                        <tr>
                                            <th>
                                                <input class="btn btn-primary btn-md" id="section_save"
                                                       value="► Save Setting" type="button">
                                                <span id="save_setting_loading_image" style="display: none">
                                                     {!! Html::image('image/select.gif') !!}
                                                </span>
                                            </th>
                                            <th colspan="5"></th>
                                        </tr>
                                        </tfoot>

                                    </table>

                                </div><!-- /.box-body -->
                            </div><!-- /.box -->
                        </div>
                    </div> <!--row last-->
                </div>
            </div>
        </div>
    </div>
@endsection





@section('scripts')

    @parent

    {{--{!! Html::script('select/js/select2.min.js') !!}--}}


    <script type="text/javascript">
        $(document).ready(function () {


            $("#section_save").on("click", function () {

                var timetableId = $('#timetable_id').val();


                var arraySectionIds = new Object();

                $(".section_cb:checkbox:checked").each(function () {
                     arraySectionIds[$(this).val()] = $(this).val();
                });
                var size = Object.keys(arraySectionIds).length;

                if (size <= 0) {
                    $.growl.warning({message: "Select at least one weekday to continue!"});
                    return
                }
                $("#save_setting_loading_image").css('display', 'inline');


               console.log(timetableId)

             //   return

                $.ajax({
                    type: "POST",
                    url: '{{route('save-section-for-timetable')}}',
                    data: {
                        data: arraySectionIds,
                        'timetableId': timetableId
                    }
                }).done(function (data) {

                    console.log(data);
                    $.growl.notice({message: data.message});

                }).fail(function (data) {
                    console.log(data);
                    $.growl.warning({message: data.statusText});
                }).always(function () {
                    $("#save_setting_loading_image").css('display', 'none');
                });


            });

        });
    </script>



@endsection




























