@extends('default.admin.layouts.master')

@section('style')
    {!! Html::style('css/styles.css') !!}

    {!! Html::style('css/routine.css') !!}
    {!! Html::style('css/H-confirm-alert.css') !!}


@endsection

@section('content')

    <div class="container-fluid min_height_area">
        <div class="row">
            <div class="col-md-12">
                <div class="student-box-header">
                    <div class="col-md-6 col-xs-5">
                        <span class="glyphicon glyphicon-user "
                              aria-hidden="true"></span>{{ trans('sidebar.time_table_entry') }}
                    </div>
                    <div class="col-md-6 col-xs-7 snt">
                     {{--   <ul class="breadcrumb text-right">
                            <li>
                                <span class="glyphicon glyphicon-folder-close" aria-hidden="true"></span>
                                <a href="#">{{ trans('sidebar.dashboard') }}</a></li>
                            <li class="active">{{ trans('sidebar.time_table_entry') }}</li>
                        </ul>--}}
                    </div>
                </div>
            </div>
        </div> <!--row-->
        <div class="row">
            <div class="col-md-12">

                <div class="view-header">
                    <button onclick="javascript:window.print()" class="btn btn-primary"><span
                                class="fa fa-print"></span> {{ trans('translate.print') }}
                    </button>
                    <button onclick="javascript:window.print()" class="btn btn-primary"><span
                                class="fa fa-file"></span> {{ trans('translate.print_preview') }}
                    </button>
                    <button class="btn btn-primary"><span class="fa fa-file"></span> {{ trans('translate.edit') }}
                    </button>

                </div>
            </div>

            <div class="col-xs-12 col-sm-12 col-md-12" style="padding-bottom: 8px;">
                <div class="col-xs-8 col-sm-6 col-md-3" style="background-color:#367fa9; color: white; text-align: center;">
                    <input title="" type="hidden" value="{{$theTimetable->id}}" id="timetable-id">

                    {{date('d F o', strtotime($theTimetable->start_date)) }}
                    <i class="fa fa-arrow-right"></i>
                    {{date('d F o', strtotime($theTimetable->end_date))}}
                </div>

            </div>

            <div class="col-md-2">

                <label for="">Class Name: </label>
                <select class="form-control" title="" id="student_class_id">
                    @foreach($classList as $k=>$value)
                        <option value="{{$value->id}}">{{$value->class_name}}</option>
                    @endforeach
                </select>
                <span id="class_change_loading_image"  style="display: none">{!! Html::image('image/select.gif') !!}</span>

            </div>

            <div class="col-md-2">
                <label for="">Section Name: </label>
                <select class="form-control" title="" id="section_id">
                    <option value="0">Section</option>
                </select>
                <span id="section_change_loading_image" style="display: none"> {!! Html::image('image/select.gif') !!}</span>

                <a id="section_reload" style="display: none;" href="#" class="btn btn-xs btn-info">Reload</a>
            </div>


        </div> <!--row-->


      <div class="inner-box" id="timetable-entries-list">

        </div>


    </div>
@endsection




@section('scripts')


    @parent


    {!! Html::script('js/H-confirm-alert.js') !!}


    <script type="text/javascript">
        $(document).ready(function () {

            var sectionId={{$sectionId}}

//console.log(sectionId)


            $('#student_class_id').val({{$class->student_class_id}})



            getSection();

            function getSection() {
                $("#section_reload").css('display', 'none')
                $(".successOrErrorMsgDiv").css('display', 'none');
                $('#timetable-entries-list').html('');
                var host = window.location.origin;
                $("#class_change_loading_image").css('display', 'inline');
                var studentClassId = $('#student_class_id').find('option:selected').val();
                $.ajax({
                    'url': host + '/section/list-by-class/' + studentClassId,
                    'dataType': 'json'
                }).success(function (data) {
                    console.log(data);
                    var sectionForClass = "<option value=''>Select Section</option>";
                    $(data[0]).each(function (index, item) {
                        sectionForClass += "<option value =" + item.id + ">" + item.section_name + " </option>";
                    });
                    $('#section_id').html(sectionForClass);
                    $('#section_id').val(sectionId);
                    getList();

                }).error(function () {
                    $("#section_reload").css('display', 'inline')

                }).complete(function () {
                    $("#class_change_loading_image").css('display', 'none')
                })
            }


            $('#student_class_id').change(function () {
                getSection();

            });



            function getList() {
                $(".successOrErrorMsgDiv").css('display', 'none');
                $('#timetable-entries-list').html('');
                var host = window.location.origin;
                var timetableId = $('#timetable-id').val();
                var studentSectionId = $('#section_id').find('option:selected').val();

                console.log(timetableId);
                console.log(studentSectionId);
                if (!studentSectionId) return;

                $("#section_change_loading_image").css('display', 'inline');

                $.ajax({
                    type: "GET",
                    url: host + '/timetable/get-timetable-entries-list/' + timetableId + '/' + studentSectionId,
                    // data: myusername,
                    cache: false
                }).done(function (data) {
                   // console.log(data)

                    $data = $(data);
                    $('#timetable-entries-list').html($data);

                }).fail(function () {
                    $.growl.warning({message: "Something Went Wrong!"});
                }).always(function () {
                    $("#section_change_loading_image").css('display', 'none');
                });
            }

            $('#section_id').change(function (e) {
                e.preventDefault();
                getList()

            });
            $("#section_reload").on("click", function () {
                getSection();
            });




            $("#timetable-entries-list").on("mouseover", '.drop', function () {

                var id = $(this).attr("id");
                $("#" + id + " .class_timing_tooltip").css('display', 'block');

                $("#" + id + " .cross_section").removeClass('inactive_div')
            }).on("mouseout", '.drop', function () {
                var id = $(this).attr("id");
                $("#" + id + " .class_timing_tooltip").css('display', 'none');
                $("#" + id + " .cross_section").addClass('inactive_div')
            });


            $("#timetable-entries-list").on("mouseover", '.cross_section', function () {
                $(".cross_section").addClass('red_back');
            }).on("mouseout", '.drop', function () {
                $(".cross_section").removeClass('red_back')
            });

            $("#timetable-entries-list").on("click", '.cross_section', function () {
                var id = $(this).attr("id").replace('remove_', '');

                $(function(){
                    $.confirm.show({
                        "message":"Sure To Remove Subject And Teacher?",
                        "type":"warning",// or success, danger, warning
                        "yes":function(){
                          /*  $.confirm.show({
                                "message":"Welcome!",
                                "noText":"Cancel",
                                "type":"success",
                            })*/

                            $.ajax({
                                type: "GET",
                                url: '{{route('remove-timetable-entries-slot-data')}}',
                                data: {
                                    slotId: id
                                }
                            }).done(function (data) {
                                $.growl.notice({message: 'Successfully Removed!'});
                                getList()

                            }).fail(function (data) {
                                $.growl.warning({message: 'Oops, Something Went Wrong!'});

                            }).always(function () {
                                $("#assign_button_loading_image").css('display', 'none');
                            });
                        }
                    })
                })

            })


            $("#timetable-entries-list").on("click", '.drop', function () {
                var id = $(this).attr("id");
                $(this).find('input[type=checkbox]').prop("checked", !$(this).find('input[type=checkbox]').prop("checked"));

            });

            $("#timetable-entries-list").on("click", '.employees_subject', function () {
                var id = $(this).attr("id");
                $("#" + id + " .tick_plus").toggleClass("selectable selected");
            });




            $("#timetable-entries-list").on("click", '#building_id', function () {

                var host = window.location.origin ;
                var buildingId = $('#building_id').find('option:selected').val();
                console.log(buildingId);
                $.ajax({
                    'url': host + '/floor/' + buildingId,
                    'dataType': 'json'
                }).success(function (data) {
                    //console.log(data);
                    var floorForBuilding = "<option value=''>Select Floor</option>";
                    $(data[0]).each(function(index,item){
                        floorForBuilding += "<option value ="+ item.id +">"+item.floor_name+" </option>";
                    });
                    $('#floor_id').html(floorForBuilding);
                })
            });

            /*start choose room onchange event of floor*/
                $("#timetable-entries-list").on("change", '#floor_id', function () {

                var host = window.location.origin;
                var floorId = $('#floor_id').find('option:selected').val();
                $.ajax({
                    'url': host + '/room/' + floorId,
                    'dataType': 'json'
                }).success(function (data) {
                    //console.log(data);
                    var roomForFloor = "<option value=''>Select Room</option>";
                    $(data[0]).each(function(index,item){
                        roomForFloor += "<option value ="+ item.id +">"+item.room_name+" </option>";
                    });
                    $('#room_id').html(roomForFloor);
                   /* console.log(data);
                    var roomForFloor = "";
                    $(data[0]).each(function(index,item){

                        roomForFloor += '<div class="employees_subject room" id="room_'+ item.id +'" title="'+item.room_name +'">' +
                                ' <div class="tick_plus selectable"  id="'+ item.id +'" style="top: 1px;"></div>' +
                                ' <div class="employee_name">'+item.room_name +'</div> </div>';
//                        roomForFloor += "<option value ="+ item.id +">"+item.room_name+" </option>";
                    });
                    $('#room_id').html(roomForFloor);*/
                })
            });


            $("#timetable-entries-list").on("click", '#assign_button', function () {

                var slotIds_obj = [];

                var slotIds = $('.select_check_box :checkbox:checked').map(function () {
                    var id = this.id;
                    var final = id.replace('accept_', ' ');
                    return final;
                }).get();

                var subject_id = $("#subject_id").val();
                var room_id = $("#room_id").val();

               //console.log(subject_id);

                var employees_obj = [];

                $(".employees .selected").each(function () {
                    employees_obj.push($(this).attr('id'))
                });
                /*var room_obj = [];

                $(".rooms .selected").each(function () {
                    room_obj.push($(this).attr('id'))
                });*/

                console.log('slot: '+slotIds);
                console.log('subject: '+subject_id);
                console.log('room: '+room_id);
                console.log('employee: '+employees_obj.join(','));


                if (slotIds.length <= 0) {
                    $.growl.warning({message: 'Select At least one Slot!'});
                    return
                }

                if (employees_obj.length <= 0 && !subject_id) {
                    $.growl.warning({message: 'Select At least one Teacher Or Subject!'});
                    return
                }

                $("#assign_button_loading_image").css('display', 'inline');
                $.ajax({
                    type: "Post",
                    url: '{{route('save-timetable-entries-slot-data')}}',
                    data: {
                        data: employees_obj.join(','),
                        'subjectId': subject_id,
                        'slotIds': slotIds,
                        'rooms': room_id
                    }
                }).done(function (data) {
                    console.log('back' + data);
                    $.growl.notice({message: 'Successfully Saved!'});
                    getList()

                }).fail(function (data) {
                    $.growl.warning({message: 'Oops, Something Went Wrong!'});

                }).always(function () {
                    $("#assign_button_loading_image").css('display', 'none');
                });


            });

        });
    </script>



@endsection

