@extends('layouts.auth')
@section('content')
    <div class="login-box">
        <div class="login-box-body">
            <div class="login-logo">
                @if(Session::get('USER_TYPE') == 'eduworld')
                    <img class="logo-image-transparent" width="160" src="{!! asset('image/edu.png') !!}"/>
                @else
                    <img class="logo-image-transparent" width="70" src="{!! asset(Session::get('LOGO_PATH')) !!}">
                @endif
            </div>

            <p style="font-size: 17px" class="text-center">{{Session::get('FULL_NAME')}}</p>

            <p class="login-box-msg"></p>
            @if (count($errors) > 0)
                <div class="alert alert-danger">
                    @foreach ($errors->all() as $error)
                        <i class="fa fa-warning"></i>   {{ $error }} <br>
                    @endforeach
                </div>
            @endif
            <form role="form" method="POST" action="{{ route('log-in') }}">
                {{ csrf_field() }}

                <div class="form-group has-feedback{{ $errors->has('email') ? ' has-error' : '' }}">
                    <input name="email" style="border-radius: 10px" type="text" class="form-control"
                           placeholder="{{ trans('general.email') }} Or Username"
                           required autofocus>
                    <span class="glyphicon glyphicon-user form-control-feedback"></span>
                    @if ($errors->has('email'))
                        <span class="help-block">
                <strong>{{ $errors->first('email') }}</strong>
            </span>
                    @endif
                </div>

                <div class="form-group has-feedback{{ $errors->has('password') ? ' has-error' : '' }}">
                    <input id="myInput" name="password" style="border-radius: 10px" type="password" class="form-control"
                           placeholder="{{ trans('auth.password.current') }}" required>
                    <span class="glyphicon glyphicon-lock form-control-feedback"></span>
                    @if ($errors->has('password'))
                        <span class="help-block">
                <strong>{{ $errors->first('password') }}</strong>
            </span>
                    @endif
                </div>


                <div class="row">
                    @stack('remember_input_start')
                    <div class="col-sm-12 text-center">
                        <label class="checkbox-inline">
                            <input name="remember" type="checkbox" {{ old('remember') ? 'checked' : '' }}>
                            {{ trans('auth.remember_me') }}
                        </label>

                        <label class="checkbox-inline">
                            <input type="checkbox" onclick="myFunction()">Show Password
                        </label>


                    </div>
                    <div class="col-sm-12 text-center">
                        <button type="submit" style="max-width: 200px; text-align: center;border-radius: 6px"
                                class="btn btn-primary btn-block btn-flat center-block"> {{ trans('auth.login') }}</button>

                    </div>
                    <!-- /.col -->
                </div>
            </form>
            <a href="{{ route('password.request') }}">{{ trans('auth.forgot_password') }}</a><br>
            {{--   <div class="text-center">
                   @if($std_registration_declared_time_present==1)
                       <a class="btn btn-primary btn-xs" href="{{ route('site-student-entry-application-form') }}" target="_blank">Student
                           Entry Form</a>
                   @endif
               </div>--}}

        </div>
        <!-- /.login-box-body -->

        <div class="login-box-footer">
            <i>{{ trans('footer.powered') }}</i> <a href="{{ trans('footer.link') }}" target="_blank"> <b>Edu world</b>
            </a>
        </div>
        <!-- /.login-box-footer -->

    </div>
    <script>
        function myFunction() {
            var x = document.getElementById("myInput");
            if (x.type === "password") {
                x.type = "text";
            } else {
                x.type = "password";
            }
        }
    </script>

@endsection
