<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="_token" content="{!! csrf_token() !!}"/>
    <link rel="shortcut icon" type="image/png" href="/image/logo.ico"/>
    <link rel="shortcut icon" type="image/png" href="/image/logo.ico"/>
    <title>{{Session::get('FULL_NAME') ?? Session::get('ALIAS')}} | {{$viewType}}</title>
    <!-- Tell the browser to be responsive to screen width -->
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <!-- Bootstrap 3.3.5 -->

{!! Html::style('theme_components/admin/bootstrap/css/bootstrap.min.css') !!}
{{--{!! Html::style('css/jquery-ui.css') !!}--}}

<!-- Font Awesome -->
{!! Html::style('css/font-awesome.min.css') !!}

{{--{!! Html::style('https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css') !!}--}}
{{--<link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.4.1/css/all.css" integrity="sha384-5sAR7xN1Nv6T6+dT2mhtzEpVJvfS3NScPQTrOxhwjIuvcA67KV2R5Jz6kr4abQsz" crossorigin="anonymous">--}}

<!-- Theme style -->
{!! Html::style('theme_components/admin/dist/css/AdminLTE.min.css') !!}

<!-- admin Skins. Choose a skin from the css/skins
         folder instead of downloading all of them to reduce the load. -->
    {!! Html::style('theme_components/admin/dist/css/skins/_all-skins.min.css') !!}
    <script src="{!! asset('js/sweetalert2.min.js') !!}"></script>
    {!! Html::style('css/sweetalert2.min.css') !!}
    {!! Html::style('css/jquery.growl.css') !!}

    {!! Html::style('css/styles.css') !!}
    <script src="{!! asset('jspdf/jspdf.min.js') !!}"></script>
    @yield('style')

    <style>


        #toTop p {
            margin-bottom: 15px;
        }

        #toTop {
            position: fixed;
            bottom: 50px;
            right: -51px;
            width: 84px;
            cursor: pointer;
            display: none;
        }

    </style>
    <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
    {!! Html::script('theme_components/admin/maxcdn/js/html5shiv373.min.js') !!}
    {!! Html::script('theme_components/admin/maxcdn/js/respond142.min.js') !!}
    <script src="{{ asset('theme_components/admin/plugins/slimScroll/jquery.slimscroll.min.js') }}"></script>

    <![endif]-->
</head>

<body class="hold-transition skin-yellow fixed sidebar-mini">
{{--<body class="hold-transition skin-purple sidebar-mini">--}}
<div class="wrapper" id="app">
@include('default.admin.layouts.partials.header')
<!-- Left side column. contains the logo and sidebar -->
@include('default.student.layout.partials.sidebar')
<!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">

        @yield('content')

    </div><!-- /.content-wrapper -->

@include('default.admin.layouts.partials.footer')

<!-- Control Sidebar -->
{{--@include('default.admin.layouts.partials.control-sidebar')--}}
<!-- Add the sidebar's background. This div must be placed
         immediately after the control sidebar -->
    <div class="control-sidebar-bg"></div>

</div><!-- ./wrapper -->
<link rel="stylesheet" href="//code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">

<!-- jQuery 2.1.4 -->
<script src="{!! asset('theme_components/admin/plugins/jQuery/jQuery-2.1.4.min.js') !!}"></script>
<!-- Bootstrap 3.3.5 -->
<script src="{!! asset('theme_components/admin/bootstrap/js/bootstrap.min.js') !!}"></script>
<script src="{!! asset('js/jquery.growl.js') !!}"></script>

<!-- admin App --> <!-- admin sidebar menu sliding -->
{!! Html::script('theme_components/admin/dist/js/app.min.js') !!}

<!-- SlimScroll 1.3.0 -->
<script src="{!! asset('theme_components/admin/plugins/slimScroll/jquery.slimscroll.min.js') !!}"></script>

<!-- admin for demo purposes -->

{!! Html::script('js/vue/manifest.js') !!}
{!! Html::script('js/vue/vendor.js') !!}
{!! Html::script('js/vue/guardian.js') !!}
<script>
    $.ajaxSetup({
        headers: {'X-CSRF-Token': $('meta[name=_token]').attr('content')}
    });


    $(document).ready(function () {
        $(".modal").css("padding", '0px');
        $(".modal").css("padding-right", '0px');
        var currentRoute = "{{ request()->route()->getName() }}";
        console.log(currentRoute);
        $(".translation_wrap").hide();
        $(".translation_wrap.trans_en"/*+lang_def*/).show();
        $(".control_lang").on("click", function () {
            var selected_lang = $(this).val();
            $(".translation_wrap").hide();
            $(".translation_wrap.trans_" + selected_lang).show();
            $(".control_lang").val(selected_lang);
        });

        setTimeout(function () {
            $('#successMessage').fadeOut('slow');
        }, 5000);

        $('.datepick').datepicker({
            format: 'mm/dd/yyyy',
        }).on('changeDate', function (e) {
            $(this).datepicker('hide');
        });

        $(window).scroll(function (e) {
            //  e.preventDefault();
            if ($(this).scrollTop() > 50) {
                $('#toTop').stop().css({opacity: 1, "display": "inline"}).fadeOut(3000);
            }
        });

        $('#toTop').click(function () {
            $('body,html').animate({scrollTop: 0}, 800);
        });

        var url = window.location.href.split('#')[0];
        var element = $('ul.sidebar-menu a').filter(function () {
            console.log(url);
            return this.href == url;
        });

        $(element).parentsUntil('ul.sidebar-menu', 'li').addClass('active');

    });


</script>
@section('scripts')

@show
<div id="toTop">
    <i class="fa fa-arrow-circle-up fa-2x" aria-hidden="true"></i>
</div>
</body>
</html>
