@extends('default.site.layout.master')
@section('style')
    <style>
        .row.display-flex {
            display: flex;
            flex-wrap: wrap;
            margin-right: 0;
            margin-left: 0;
        }

        .row.display-flex > [class*='col-'] {
            display: flex;
            flex-direction: column;
        }

        /* not requied only for demo * */
        .row [class*='col-'] {
            background-colo: #cceeee;
            background-clip: content-box;
        }

        .block {
            display: block;
            width: 100%;
            text-align: center;
        }

    </style>
@endsection
@section('content')

    <div class="container-fluid min_height_area">
        <div class="row">

            <div class="col-md-12 no-padding">
                <div class="view-header">
                    <section class="content-header">
                        <ol class="breadcrumb">
                            <li>
                                <span class="fa fa-dashboard" aria-hidden="true"></span>
                                <a href="{{route('admin')}}">{{ trans('translate.dashboard') }}</a></li>
                            <li class="active text-capitalize">Employee Enrolment</li>
                        </ol>
                    </section>
                </div>
            </div>

        </div>


        <div class="row inner-box-1">
            <employee-attach-component
                get-site-base-country-list="{{route('get-site-base-country-list',[Session::get('SITE_ID')])}}"
            >
            </employee-attach-component>
        </div>
    </div>

@endsection

@section('hscripts')


    <script>


        window.routes = {
            'route_site_employee_report': '{{ route('site-employee-get-employee-report') }}',
            'route_site_employee_get_list_by_search': '{{ route('site-employee-get-all-employee-by-search') }}',

        }
    </script>
@endsection
