@extends('default.site.layout.master')

@if(Auth::check())
    @set('authUser',request()->user())
@endif


@section('content')

    <div class="container-fluid min_height_area">
        <div class="row">
            <div class="col-md-12">
                <div class="view-header">
                    <section class="content-header">
                        <ol class="breadcrumb">
                            <li>
                                <span class="fa fa-dashboard" aria-hidden="true"></span>
                                <a href="{{route('admin')}}">{{ trans('translate.dashboard') }}</a></li>
                            <li class="active text-capitalize">User Profile</li>
                        </ol>
                    </section>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-3">

                <!-- Profile Image -->
                <div class="box box-primary">
                    <logged-common-user-profile-pic></logged-common-user-profile-pic>

                </div><!-- /.box -->

                <!-- About Me Box -->
            {{--  <div class="box box-primary">
                  <div class="box-header with-border">
                      <h3 class="box-title">About Me</h3>
                  </div><!-- /.box-header -->
                  <div class="box-body">
                      <strong><i class="fa fa-book margin-r-5"></i> Education</strong>
                      <p class="text-muted">
                          B.S. in Computer Science from the University of Tennessee at Knoxville
                      </p>

                      <hr>

                      <strong><i class="fa fa-map-marker margin-r-5"></i> Location</strong>
                      <p class="text-muted">Malibu, California</p>

                      <hr>

                      <strong><i class="fa fa-pencil margin-r-5"></i> Skills</strong>
                      <p>
                          <span class="label label-danger">UI Design</span>
                          <span class="label label-success">Coding</span>
                          <span class="label label-info">Javascript</span>
                          <span class="label label-warning">PHP</span>
                          <span class="label label-primary">Node.js</span>
                      </p>

                      <hr>

                      <strong><i class="fa fa-file-text-o margin-r-5"></i> Notes</strong>
                      <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam fermentum enim neque.</p>
                  </div><!-- /.box-body -->
              </div>--}}

            <!-- /.box -->
            </div><!-- /.col -->
            <div class="col-md-9">
                <div class="nav-tabs-custom">
                    <ul class="nav nav-tabs">
                        <li class=""><a href="#activity" data-toggle="tab" aria-expanded="false">Activity</a></li>
                        <li class=""><a href="#timeline" data-toggle="tab" aria-expanded="false">Timeline</a></li>
                        <li class="active"><a href="#settings" data-toggle="tab" aria-expanded="true">Settings</a>
                        </li>
                    </ul>
                    <div class="tab-content">
                        <div class="tab-pane" id="activity">
                            <!-- Post -->
                            <div class="post">
                                <div class="user-block">

                        <span class="username">
                          <a href="#">{{Auth::user()->full_name}}</a>

                        </span>
                                    <span class="description">You are active user</span>
                                </div><!-- /.user-block -->

                            </div><!-- /.post -->


                        </div><!-- /.tab-pane -->
                        <div class="tab-pane" id="timeline">
                            <!-- The timeline -->
                            <h2>Timeline</h2>
                        </div><!-- /.tab-pane -->

                        <div class="tab-pane active" id="settings">

                            <logged-common-user-setting>

                            </logged-common-user-setting>
                        </div><!-- /.tab-pane -->
                    </div><!-- /.tab-content -->
                </div><!-- /.nav-tabs-custom -->
            </div><!-- /.col -->

        </div>
    </div>

@endsection
