<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no'
          name='viewport'>

    <title>{{$page_tittle}}</title>

    <style>

        @font-face {
            font-family: 'Verdana';
            font-weight: 100;
            font-style: normal;
            font-variant: normal;
            src: url("{{public_path()}}/fonts/Verdana.ttf") format("truetype");
        }

        body {
            font-family: "Verdana", sans-serif;
            font-size: 12px;
        }

        .th-bg {
            background-color: #87adbd;
            color: #FFFFFF;
        }

        .data-table td {
            border: 1px dotted #999999;
            text-align: center;
        }


    </style>

</head>
<body>


@include('default.site.layout.pdf-header')


<div>
    <table class="data-table" cellspacing="0" border="0" width="100%;" style="">

        <thead class="th-bg">
        <tr>
            <td style="width: 1px">S/L</td>
            <td>Date</td>
            <td>In</td>
            <td>Out</td>
            <td>Status</td>

        </tr>
        </thead>


        <tbody>
        @foreach($final_data as $key => $value)

            <tr>
                <th colspan="5" style="text-align: left">
                    ({{$key+1}}).
                    <nobr>
                        {{$value['name'] ?? 'na'}}
                    </nobr>
                    Roll: {{$value['roll'] ?? 'na'}}
                </th>
            

            </tr>
            @if(count($value)>=3)
            @foreach($value['data'] as $key1 => $value)
                <tr>
                    <td>{{$key1+1}}</td>
                    <td>
                        {{$value['date'] ?? '--' }}
                    </td>
                    <td>
                        {{$value['in_time'] ? date('h:i:s A',strtotime($value['in_time'])) : '--'}}
                    </td>
                    <td>
                        {{$value['out_time'] ? date('h:i:s A',strtotime($value['out_time'])) : '--'}}
                    </td>
                    <td>
                        {{$value['st_status']}}
                    </td>
                </tr>
            @endforeach
            @endif

        @endforeach
        </tbody>


    </table>
</div>


</body>


<style>

    @page {
        size: a4;
        margin: 0px;
    }

    body {
        margin: 10px 20px 50px 20px;
    }


</style>

</html>












