<!DOCTYPE html>
<html>
<head>
    @set('site',getSiteInfoForPdf())
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no'
          name='viewport'>

    <title>{{$page_tittle}}</title>

    <style>

        @font-face {
            font-family: 'Verdana';
            font-weight: 100;
            font-style: normal;
            font-variant: normal;
            src: url("{{public_path()}}/fonts/Verdana.ttf") format("truetype");
        }

        body {
            font-family: "Verdana", sans-serif;
            font-size: 12px;
        }

        .th-bg {
            background-color: #87adbd;
            color: #FFFFFF;
        }

        .data-table td {
            border: 1px dotted #999999;
            text-align: center;
        }


    </style>

</head>
<body>


@include('default.site.layout.pdf-header')


<div>
    <table class="data-table" cellspacing="0" border="0" width="100%;" style="">

        <thead class="th-bg">
        <tr>


            <td>Date</td>
            <td>Total Period</td>
            <td>Attended</td>
            <td>Absent</td>

        </tr>
        </thead>


        <tbody>
        @foreach($final_data as $key => $value)

            <tr>
                <th colspan="4" style="text-align: left">
                    ({{$key+1}})
                    <nobr>
                        {{$value['name'] ?? 'na'}}
                    </nobr>
                    Roll: {{$value['roll'] ?? 'na'}}
                </th>

            </tr>

            @foreach($value['data'] as $key => $value)
                <tr>
                    <td>
                        {{$value['date'] ?? '--' }}
                    </td>
                    <td>
                        {{$value['total_period'] ?? '--' }}
                    </td>
                    <td>
                        {{$value['attended'] ?? '--' }}
                    </td>
                    <td>
                        {{$value['absent'] ?? '--' }}
                    </td>
                </tr>
            @endforeach


        @endforeach
        </tbody>


    </table>
</div>


</body>


<style>

    @page {
        size: a4;
        margin: 0px;
    }

    body {
        margin: 10px 20px 50px 20px;
    }


</style>

</html>












