<?php

/**
 * Created by PhpStorm.
 * User: raja
 * Date: 4/17/16
 * Time: 10:54 AM
 */

//===========================================================StudentPanel=====================================================================


Route::group(['namespace' => 'Site'], function () {
    Route::group(['namespace' => 'StudentPanel', 'prefix' => 'student'], function () {

        Route::group(['namespace' => 'Result', 'prefix' => 'result'], function () {
            Route::get('master', 'StudentExamResultController@index')->name('student-exam-result-master-form');
            Route::get('site-student-all-history-list', 'StudentExamResultController@siteStudentAllHistoryList')->name('site-student-all-history-list');
            Route::post('get-primary-result-list-for-student', 'StudentExamResultController@getPrimaryResultListForStudent')->name('get-primary-result-list-for-student');
            Route::post('get-primary-result-type-result-detail-for-student', 'StudentExamResultController@getPrimaryResultTypeResultDetailForStudent')->name('get-primary-result-type-result-detail-for-student');
            Route::post('get-primary-result-type-result-detail-for-student-pdf', 'StudentExamResultController@getPrimaryResultTypeResultDetailForStudentPdf')->name('get-primary-result-type-result-detail-for-student-pdf');
        });


        Route::group(['namespace' => 'Quiz', 'prefix' => 'quiz'], function () {
            Route::get('master', 'StudentQuizController@index')->name('student-quiz-master');
            Route::get('start/{quiz_declare_id}', 'StudentQuizController@index')->name('student-quiz-start');
            Route::get('active-list', 'StudentQuizController@getStudentActiveQuizList')->name('student-quiz-active-list');
            Route::get('present-quiz-info', 'StudentQuizController@getStudentPresentActiveQuizInfo')->name('student-present-quiz-quiz-info');
            Route::get('quiz-routine-list', 'StudentQuizController@getStudentActiveQuizRoutineList')->name('student-present-quiz-routine-list');
            Route::post('previews-quiz-list', 'StudentQuizController@getStudentPreviewsQuizList')->name('student-previews-quiz-list');
            Route::post('quiz-start', 'StudentQuizController@quizStartByStudnet')->name('student-quiz-quiz-start');
           // Route::get('quiz-start-info/{id}', 'StudentQuizController@quizStartByStudnet')->name('student-quiz-quiz-start-info');
         
            Route::get('get-quiz-question-list-for-student/{quiz_delare_id}', 'StudentQuizController@getQuizQuestionListForStudent')->name('get-quiz-question-list-for-student');
            Route::post('student-quiz-answer-silent-save', 'StudentQuizController@studentQuizAnswerSilentSubmit')->name('student-quiz-answer-silent-save');
            Route::post('student-quiz-answer-submit', 'StudentQuizController@studentQuizAnswerSubmit')->name('student-quiz-answer-submit');
            
        });

        Route::group(['namespace' => 'Exam', 'prefix' => 'exam'], function () {
            Route::get('master', 'StudentExamController@index')->name('student-exam-master-form');
            Route::post('get-exam-type-list-for-student', 'StudentExamController@getExamTypeListForStudent')->name('get-exam-type-list-for-student');
            Route::post('get-exam-subject-date-for-student', 'StudentExamController@getExamSubjectDateForStudent')->name('get-exam-subject-date-for-student');
            Route::post('get-exam-clearence-detail-for-student', 'StudentExamController@getExamClearenceDetailForStudent')->name('get-exam-clearence-detail-for-student');
            Route::post('ensure-prepared-for-exam-by-student', 'StudentExamController@ensurePreparedForExamByStudent')->name('ensure-prepared-for-exam-by-student');
            Route::post('apply-for-exam-restart-by-student', 'StudentExamController@applyForExamRestartByStudent')->name('apply-for-exam-restart-by-student');


            Route::get('start/{id}', 'StudentExamController@examStart')->name('exam-start-from-student');
            Route::post('get-question-list-for-student', 'StudentExamController@getQuestionListForStudent')->name('get-question-list-for-student');
            Route::post('student-exam-answer-silent-save', 'StudentExamController@studentExamAnswerSilentSave')->name('student-exam-answer-silent-save');
            Route::post('student-exam-answer-submit', 'StudentExamController@studentExamAnswerSubmit')->name('student-exam-answer-submit');
        
            Route::post('get-exam-admit-card-for-student-pdf', 'StudentExamController@studentExamDetailForAdmitCardPdfFroApi')->name('get-exam-admit-card-for-student-pdf');

            

        });

        Route::group(['namespace' => 'Transaction', 'prefix' => 'transaction'], function () {
            Route::get('master', 'StudentTransactionController@index')->name('edu-student-transaction-master-form');
            Route::get('get-student-edu-invoice-list-for-transaction', 'StudentTransactionController@getStudentEduInvoiceListForTransaction')->name('get-student-edu-invoice-list-for-transaction');
            Route::get('get-online-payment-method-list-for-transaction', 'StudentTransactionController@getOnlinePaymentMethodListForTransaction')->name('get-online-payment-method-list-for-transaction');
            Route::post('get-payment-base-page-for-transaction', 'StudentTransactionController@getPaymentBasePageForTransaction')->name('get-payment-base-page-for-transaction');

            Route::post('get-student-payment-base-page-for-nagad-transaction', 'SiteStudentTransactionController@getPaymentDetailsForNagadTransaction')->name('get-student-payment-base-page-for-transaction');
            Route::post('get-student-payment-base-page-for-transaction-with-transaction-id', 'SiteStudentTransactionController@getPaymentDetailsForTransactionWithTransactionID')->name('get-student-payment-base-page-for-transaction-with-transaction-id');
            Route::post('check-payment-details-with-transaction-id', 'SiteStudentTransactionController@checkPaymentDetailsWithTransactionID')->name('get-student-check-payment-details-with-transaction-id');

            Route::post('download-edu-student-payment-voucher', 'StudentTransactionController@downloadEduStudentPaymentVoucher')->name('download-edu-student-payment-voucher');


            Route::get('get-nagad-edu-callback-website', 'StudentTransactionController@getNagadEduCallbackWebsite')->name('get-nagad-edu-callback-website');
            Route::get('get-nagad-site-student-callback-website', 'SiteStudentTransactionController@getNagadSiteStudentCallbackWebsite')->name('get-nagad-site-student-callback-website');


            Route::post('get-token', 'SiteStudentTransactionController@getToken')->name('get-token');
//            Route::post('get-bkash-token', 'SiteStudentTransactionController@getBkashToken')->name('get-bkash-token');
//            Route::post('get-config-file', 'SiteStudentTransactionController@getConfigFile')->name('get-config-file');
            Route::get('create-bkash-payment', 'SiteStudentTransactionController@createBkashPayment')->name('create-bkash-payment');
            Route::get('execute-bkash-payment', 'SiteStudentTransactionController@executeBakashPayment')->name('execute-bkash-payment');


            Route::post('get-student-payment-info-for-gateway', 'SiteStudentTransactionController@getStudentPaymentInfoForGateway')->name('get-student-payment-info-for-gateway');
         
            Route::post('sonali-pay-transaction-message', 'SiteStudentTransactionController@checkSonaliPayTokenMode')->name('sonali-pay-transaction-message');

        });


        Route::group(['namespace' => 'Attendance', 'prefix' => 'attendance'], function () {
            Route::get('leave', 'AttendanceController@master')->name('site-student-panel-attendance-master');
            Route::get('my-attendance', 'AttendanceController@master')->name('site-student-panel-attendance-master');
            Route::get('periodic-attendance', 'AttendanceController@master')->name('site-student-panel-attendance-master');
            Route::get('routine', 'AttendanceController@master')->name('site-student-panel-attendance-master');


            Route::get('get-student-individual-attendance', 'AttendanceController@getIndividualAttendance')->name('site-student-panel-get-student-individual-attendance');
            Route::get('get-routine-period-list', 'AttendanceController@getPeriodList')->name('site-student-panel-get-student-individual-attendance-get-routine-period-list');
            Route::get('get-routine-report', 'AttendanceController@getRoutinePdf')->name('site-student-panel-get-student-individual-attendance-get-routine-report');
            Route::post('save-periodic-attendance', 'AttendanceController@savePeriodicAttendance')->name('site-student-periodic-save-periodic-attendance');


            Route::group(['prefix' => 'leave'], function () {

                Route::post('get-leave-list', 'LeaveController@getLeaveList')->name('site-student-panel-attendance-leave-get-leave-list');
                Route::post('add', 'LeaveController@create')->name('site-student-panel-attendance-leave-create');
                Route::put('update', 'LeaveController@update')->name('site-student-panel-attendance-leave-update');
                Route::delete('delete', 'LeaveController@delete')->name('site-student-panel-attendance-leave-delete');

            });
        });

        Route::group(['prefix' => 'payment'], function () {
            Route::get('payment-with-wallet', 'StudentController@payment')->name('site-student-payment-master');
            Route::get('payment-list', 'StudentController@payment')->name('site-student-payment-list-master');
            Route::get('payment-with-transaction-id', 'StudentController@payment')->name('site-student-payment-with-transaction-id');
            Route::get('check-payment-with-transaction-id', 'StudentController@payment')->name('site-student-check-payment-with-transaction-id');
            Route::get('bkash-payment', 'StudentController@testingpaymentpage')->name('site-student-payment-bkash-payment');
            Route::get('payment-method-list', 'StudentController@paymentMethodList')->name('site-student-payment-payment-method-list');
            Route::get('demand-slip-details', 'StudentController@paymentDemandSlipDetails')->name('site-student-payment-demand-slip-details');
            Route::get('fee-details', 'StudentController@getPaymentFeeDetails')->name('site-student-payment-fee-details');
            Route::get('student-bank-slip-pdf', 'StudentController@getStudentBankSlipPdf')->name('site-student-bank-slip-pdf');
            Route::get('marchent-details/{name_key}', 'StudentController@getPaymentMarchentDetails')->name('site-student-payment-marchent-details');
       
            Route::get('sonali-pay-message', 'StudentController@getPaymentStatusMessage')->name('site-student-payment-status-message');

            Route::post('student-payment-list', 'StudentPaymentDetailsController@studentPaymentList')->name('site-student-payment-list');
            Route::get('student-payment-slip-pdf/{voucher_no}', 'StudentPaymentDetailsController@studentPaymentBankSlipPdf')->name('site-student-payment-slip-pdf');

        });

        Route::group(['prefix' => 'notification'], function () {
            Route::get('get-notification', 'StudentController@index')->name('site-student-message-master');
        });

    });
});


//===========================================================class room for student=====================================================================

Route::group(['namespace' => 'Api', 'prefix' => 'api'], function () {
    Route::group(['namespace' => 'Site', 'prefix' => 'site'], function () {
        Route::group(['namespace' => 'Web', 'prefix' => 'student'], function () {
            Route::group(['namespace' => 'Setting', 'prefix' => 'class-room'], function () {
                Route::get('view', 'ClassRoomController@studentClassLessonDetailsIndex')->name('site-student-class-room-view');
                Route::get('lesson-details', 'ClassRoomController@studentClassLessonDetails')->name('api-site-student-class-room-details');
            });
        });

    });
});



/*
Route::group(['namespace' => 'Site'], function () {
    Route::group(['namespace' => 'StudentPanel', 'prefix' => 'student'], function () {
        Route::group(['namespace' => 'Attendance', 'prefix' => 'attendance'], function () {

            Route::get('master', 'AttendanceController@master')->name('site-student-panel-attendance-master');

            Route::group(['prefix' => 'leave'], function () {

                Route::post('get-leave-list', 'LeaveController@getLeaveList')->name('site-student-panel-attendance-leave-get-leave-list');
                Route::post('add', 'LeaveController@create')->name('site-student-panel-attendance-leave-create');
                Route::put('update', 'LeaveController@update')->name('site-student-panel-attendance-leave-update');
                Route::delete('delete', 'LeaveController@delete')->name('site-student-panel-attendance-leave-delete');

            });
        });



    });
});*/


