<?php


Route::get('laravel-passport', 'Admin\AdminController@laravelPassport')->name('laravel-passport');


Route::group(['namespace' => 'Featured', 'prefix' => 'featured'], function () {
    Route::get('featured-list', 'FeaturedController@index')->name('edu-featured-list');
    Route::get('featured-store', 'FeaturedController@FeaturedStore')->name('featured-store');


});
Route::group(['namespace' => 'Module', 'prefix' => 'module'], function () {
    Route::get('attachment-list', 'ModuleController@attachment')->name('module-attachment-list');

    Route::get('get-module-list', 'ModuleController@getModuleList')->name('get-module-list');
    Route::get('get-sub-module-list/{id}', 'ModuleController@getSubModuleList')->name('module-get-sub-module-list');
    Route::post('save-sub-module-ids', 'ModuleController@saveSubModuleIds')->name('module-save-sub-module-ids');
    Route::get('list', 'ModuleController@index')->name('module-list');
    Route::get('add', 'ModuleController@createSiteSettingForm')->name('module-add-form');
    Route::post('add', 'ModuleController@store')->name('module-add');
    Route::get('view/{id}', 'ModuleController@edit');
    Route::put('edit/{id}', 'ModuleController@update')->name('module-module-update');
    Route::delete('delete/{id}', 'ModuleController@destroy')->name('module-delete');

});


Route::group(['namespace' => 'Menu', 'prefix' => 'menu'], function () {
    Route::get('list', 'MenuController@index')->name('menu-list');

    Route::get('add', 'MenuController@createMenuForm')->name('menu-create-form');
    Route::post('add', 'MenuController@createMenu')->name('menu-create');
    Route::patch('edit/{id}', 'MenuController@editMenu')->name('menu-edit');
    Route::get('edit/{id}', 'MenuController@editMenuForm')->name('menu-edit-form');
    Route::get('using-route-attachment/{id?}', 'MenuController@menuUsingRouteAttachment')->name('menu-using-route-attachment');
    Route::get('menu-search', 'MenuController@searchMenu')->name('menu-search');
    Route::get('get-position-list-for-parent-menu', 'MenuController@getPositionForParentMenu')->name('get-position-list-for-parent-menu');

    Route::get('menu-report/{id?}', 'MenuController@getMenuReport')->name('get-menu-report');

//    API
    Route::get('get-parent-menu-list-without-paginate', 'MenuController@getParentMenuListWithoutPaginate')->name('menu-get-parent-menu-list-without-paginate');
    Route::get('menu-get-menu-for-list', 'MenuController@getForList')->name('menu-get-menu-for-list');
    Route::get('get-displayable-menu-list-without-paginate', 'MenuController@getDisplayableMenuListWithoutPaginate')->name('menu-get-displayable-menu-list-without-paginate');
    Route::get('get-menu-list-with-routes-attached-ids-by-menu-id/{id}', 'MenuController@getMenuListWithRouteAttachedIdsByMenuId')->name('menu-get-menu-list-with-route-attached-ids-by-menu-id');
    Route::post('save-route-ids-for-menu', 'MenuController@saveRouteIdsForMenu')->name('menu-save-route-ids-for-menu');
    Route::get('get-attached-list-by-menu/{id?}', 'MenuController@getAttachedListByMenu')->name('menu-get-route-attached-list-by-menu');


});

Route::group(['namespace' => 'Module', 'prefix' => 'sub-module'], function () {
    Route::get('get-sub-module-list-with-paginate', 'SubModuleController@getSubModuleListWithPaginate')->name('sub-module-get-sub-module-list-with-paginate');


    Route::get('attached-list', 'SubModuleController@attachedList')->name('sub-module-attachment-list');

    Route::get('get-sub-modules-by-module/{id?}', 'SubModuleController@getSubModulesByModule')->name('sub-module-get-sub-modules-by-module');
    Route::get('get-sub-modules', 'SubModuleController@getSubModules')->name('sub-module-get-sub-modules');
    Route::get('get-menu-list-with-attached-list/{type}/{id?}', 'SubModuleController@getMenuListWithAttachedList')->name('sub-module-get-menu-list-with-attached-list');
    Route::get('get-attached-list-by-sub-module/{id?}', 'SubModuleController@getAttachedListBySubModule')->name('sub-module-get-attached-list-by-sub-module');
    Route::post('save-menu-ids', 'SubModuleController@saveMenuIds')->name('sub-module-save-menu-ids-for-sub-module');


    Route::post('add', 'SubModuleController@store')->name('sub-module-store');
    Route::get('edit/{id}', 'SubModuleController@edit')->name('sub-module-edit');
    Route::put('edit/{id}', 'SubModuleController@update')->name('sub-module-update');
    Route::delete('delete/{id}', 'SubModuleController@destroy')->name('sub-module-delete');


    Route::post('export-sub-modules-to-module', 'SubModuleController@exportSubModulesToModule')->name('sub-module-export-sub-modules-to-module');

});


Route::group(['namespace' => 'Package', 'prefix' => 'package'], function () {
    Route::get('attached-list', 'EduPackageController@attachedList')->name('package-module-attachment-view');
    Route::get('get-all-edu-packages', 'EduPackageController@getAllEduPackages')->name('edu-package-get-all-edu-packages');
    Route::get('get-edu-packages-for-company', 'EduPackageController@getEduPackagesForCompany')->name('edu-package-get-edu-packages-for-company');
    Route::get('get-edu-packages-for-site', 'EduPackageController@getEduPackagesForSite')->name('edu-package-get-edu-packages-for-site');
    Route::get('get-edu-packages-for-site-group', 'EduPackageController@getEduPackagesForSiteGroup')->name('edu-package-get-edu-packages-for-site-group');
    Route::get('get-attached-modules-for-the-package/{id}', 'EduPackageController@getAttachedModuleForThePackage')->name('package-get-attached-list-for-the-package');
    Route::post('package-attach-module-to-package', 'EduPackageController@assignSubModuleToGroup')->name('package-attach-module-to-package');

});


Route::group(['namespace' => 'Edu', 'prefix' => 'edu'], function () {


    Route::group(['namespace' => 'Holiday', 'prefix' => 'holiday'], function () {

        Route::get('view', 'HolidaysController@index')->name('edu-holidays-view-for-site');
        Route::get('form-data', 'HolidaysController@getFormData')->name('get-form-data-for-holiday');
        Route::get('holiday-list/{holidaytypeid}', 'HolidaysController@getHolidayList')->name('get-holiday-list');
        Route::post('add', 'HolidaysController@createHoliday')->name('create-holiday-for-site');
        Route::get('government-holiday-list', 'HolidaysController@getGovernmentHolidayList')->name('get-government-holiday-data-list');

    });

    Route::group(['namespace' => 'GlobalAcademicCalendar', 'prefix' => 'global-calendar'], function () {
        Route::get('index', 'GlobalAcademicCalendarController@index')->name('global-calendar-index');
        Route::get('head-list', 'GlobalAcademicCalendarController@getAcademicCalenderHeadList')->name('get-edu-calendar-head-list');
        Route::post('add', 'GlobalAcademicCalendarController@createEvent')->name('edu-event-create');
        Route::post('edit', 'GlobalAcademicCalendarController@editAcademicCalendarEvent')->name('edu-event-edit');
        Route::post('delete', 'GlobalAcademicCalendarController@deleteAcademicCalendarEvent')->name('edu-event-delete');
        Route::post('headwise-delete-event', 'GlobalAcademicCalendarController@deleteHeadwiseEvent')->name('edu-headwise-delete-event');
        Route::get('list', 'GlobalAcademicCalendarController@getGlobalAcademicCalendarEventList')->name('edu-calendar-event-list');
        Route::get('calendar-subhead-color-list/{acSubHeadId?}', 'GlobalAcademicCalendarController@getCalendarSubHeadColorList')->name('get-edu-calendar-sub-head-color-list');
        Route::get('calendar-list/{monthIncrement?}', 'GlobalAcademicCalendarController@getCalendarList')->name('get-edu-calendar-list');
        Route::get('calendar-title-list/{headId?}', 'GlobalAcademicCalendarController@getCalendarTitleList')->name('get-edu-calendar-title-list-by-head-id');
        Route::get('yearly-calendar-list/{academic_year?}', 'GlobalAcademicCalendarController@getYearlyCalendarList')->name('get-edu-yearly-calendar-list');
//        Route::get('calendar-subhead-color-list/{acSubHeadId?}', 'GlobalAcademicCalendarController@getCalendarSubHeadColorList')->name('get-calendar-sub-head-color-list');
    });


    Route::group(['namespace' => 'DashboardPalette', 'prefix' => 'dashboard-palette'], function () {

        Route::get('list', 'DashboardPaletteController@index')->name('edu-dashboard-palette-list');

        //API
        Route::get('get-dashboard-palette-list', 'DashboardPaletteController@getDashboardPaletteList')->name('edu-dashboard-palette-get-dashboard-palette-list');
        // Route::get('get-dashboard-palettes-with-paginate', 'RoleController@getRolesWithPaginate')->name('edu-dashboard-palette-get-role-list-with-paginate');
        Route::post('add', 'DashboardPaletteController@store')->name('edu-dashboard-palette-create');
        Route::get('delete/{ifetchd}', 'DashboardPaletteController@deleteRole')->name('edu-dashboard-palette-delete');
        Route::put('edit/{id}', 'DashboardPaletteController@update')->name('edu-dashboard-palette-update');

    });

    Route::group(['namespace' => 'Company', 'prefix' => 'company'], function () {

        Route::get('list', 'CompanyController@index')->name('edu-company-company-list');
        Route::post('add', 'CompanyController@create')->name('edu-company-company-add');
        Route::put('update/{id}', 'CompanyController@update')->name('edu-company-company-update');


    });

    Route::group(['namespace' => 'Fetch', 'prefix' => 'fetch'], function () {
        Route::get('edu-log-view', 'FetchLogController@studentAttendanceLog')->name('edu-site-attendance-log-view');
        Route::get('get-sms-follow-up-log', 'FetchLogController@getEduSmsFollowUpData')->name('edu-sms-get-sms-follow-up-log');
        Route::post('edu-fetch-log-fetched-log-details', 'FetchLogController@fetchedDeviceLogDetails')->name('edu-fetch-log-fetched-log-details');
        Route::get('attendance-log/{s_date_time}/{e_date_time}/{device_ids}', 'FetchLogController@fetchStudentAttendanceLog')->name('edu-fetch-attendance-log');
        Route::get('attendance-log/check-att-log-details', 'FetchLogController@checkAttLogDetails')->name('edu-check-att-log-details');


        Route::get('get-issue-log', 'FetchLogController@getIssueLog')->name('edu-issue-get-issue-log');
        Route::get('get-student-absent-log', 'FetchLogController@getStudentAbsentLog')->name('edu-issue-get-student-absent-log');
        Route::get('get-issue-types', 'FetchLogController@getIssueTypes')->name('edu-issue-get-issue-types');
        Route::get('get-sms-status-by-id', 'FetchLogController@getSmsStatusById')->name('edu-issue-get-sms-status-by-id');
        Route::post('return-sms-balance', 'FetchLogController@returnSmsBalance')->name('edu-issue-return-sms-balance');

        //backup
        Route::get('get-new-db-backup', 'FetchLogController@newDbBackup')->name('edu-db-take-new-db-backup');
        Route::get('get-db-backup-list', 'FetchLogController@getBackupList')->name('edu-db-get-db-backup-list');
        Route::get('db-backup-download', 'FetchLogController@download')->name('edu-db-get-db-backup-download');
        Route::get('db-backup-file-delete', 'FetchLogController@deleteBackupFile')->name('edu-db-backup-file-delete');

        //



    });


    Route::group(['namespace' => 'Device', 'prefix' => 'device'], function () {
        Route::get('get-device-details', 'DeviceController@getDeviceDetails')->name('edu-device-get-device-details');
        Route::post('add', 'DeviceController@add')->name('edu-device-get-device-add');
        Route::put('update/{id}', 'DeviceController@update')->name('edu-device-get-device-update');

        Route::post('edu-device-log-fetched-log-details', 'DeviceController@getLogByDateAndUsername')->name('edu-device-log-get-device-log-by-date-and-username');


    });


    Route::group(['namespace' => 'SiteGroup', 'prefix' => 'site-group'], function () {

        Route::get('list', 'SiteGroupController@index')->name('site-group-list');
        Route::get('new-site/{id}', 'SiteGroupController@index')->name('site-group-create-form');

        Route::post('add', 'SiteGroupController@createSiteGroup')->name('site-group-create');
        Route::get('edit/{id}', ['as' => 'site-group-edit-form', 'uses' => 'SiteGroupController@editSiteGroupForm']);
        Route::put('edit/{id}', 'SiteGroupController@editSiteGroup')->name('site-group-edit');
        Route::get('get-site-group-list', 'SiteGroupController@getSiteGroupList')->name('site-group-get-site-group-list');
        Route::get('get-site-group-full-list', 'SiteGroupController@getSiteGroupFullList')->name('site-group-get-site-group-full-list');
        Route::get('site-group-get-site-group-with-sites', 'SiteGroupController@getSiteGroupListWithSites')->name('edu-site-group-get-site-group-with-sites');

    });

    Route::group(['namespace' => 'Site', 'prefix' => 'site'], function () {
        Route::get('list', 'SiteController@index')->name('edu-site-list');
        Route::get('new', 'SiteController@index')->name('edu-site-new');
        Route::get('edit/{id}', 'SiteController@index')->name('edu-site-new');
        Route::get('academic-group/{id}', 'SiteController@index')->name('edu-site-new');
        Route::get('site-info-for-edit/{id}', 'SiteController@getSiteInfoForEdit')->name('site-get-site-info-by-id');


        Route::post('create', 'SiteController@createSite')->name('site-insert-update-site-information');
        Route::post('update', 'SiteController@updateSite')->name('site-insert-update-site-information');


        Route::get('application/list', 'SiteController@applicationList')->name('edu-site-new-site-application-list');
        Route::get('application/edit/{id?}', 'SiteController@applicationList')->name('edu-site-new-site-application');
        Route::get('application/approve/{id?}', 'SiteController@applicationList')->name('edu-site-new-site-application');


        Route::get('route-edu-dashboard-palette-list', 'SiteController@getDashboardPalette')->name('route-edu-dashboard-palette-list');
        Route::post('route-edu-dashboard-palette-list-upate', 'SiteController@getDashboardPaletteUpdate')->name('route-edu-dashboard-palette-list-upate');

        Route::get('get-site-list', 'SiteController@getSites')->name('edu-site-get-site-list');
        Route::get('get-site-list-or-by-group-with-pagination', 'SiteController@getSiteOrByGroupWithPagination')->name('edu-site-get-site-list-or-by-group-with-pagination');

        Route::get('get-academic-group-setting-by-site/{academic_group_id}/{site_id}', 'SiteController@getSiteGroupSelectedIdsListByAcademicGroupAndSiteGroup')->name('get-site-group-selected-ids-list-by-academic-group-and-site-group');
        Route::post('save-academic-group-setting', 'SiteController@saveAcademicGroupSetting')->name('edu-site-save-academic-group-setting');


        Route::get('get-site-details/{id}', 'SiteController@getSiteDetails')->name('edu-site-get-site-details');
        Route::get('get-academic-groups-by-site/{id}', 'SiteController@getAcademicGroupBySite')->name('get-academic-groups-by-site');


        Route::get('impersonate', 'SiteController@impersonate')->name('edu-site-impersonate-form');

        Route::get('site-list-to-impersonate', 'SiteController@getSiteToImpersonate')->name('edu-site-impersonate');
        Route::post('post-impersonate', 'SiteController@postImpersonate')->name('edu-site-impersonate');
        Route::get('selected-site-impersonate', 'SiteController@getImpersonatedSite')->name('selected-site-impersonate');

        Route::get('impersonate-site-group', 'SiteController@impersonateSiteGroup')->name('site-group-impersonate-form');

        Route::get('get-impersonate-site-group', 'SiteController@getImpersonateSiteGroup')->name('get-impersonate-site-group');

        Route::get('site-group-list-to-impersonate', 'SiteController@getSiteGroupToImpersonate')->name('site-group-impersonate');
        Route::post('post-site-group-impersonate', 'SiteController@postImpersonateSiteGroup')->name('site-group-impersonate');

        Route::get('get-year-shift-class-group-section-session-list/{id}/{accid}', 'SiteController@getYearShiftClassGroupSectionSessionList')->name('get-year-shift-class-group-section-session-list');
        Route::get('impersonate-academic-group/{id}', 'SiteController@impersonateAcademicGroup')->name('edu-impersonate-academic-group');

        Route::get('get-academic-groups-by-site-group-id/{id}', 'SiteController@getAcademicGroupListBySiteGroupId')->name('get-academic-groups-by-site-group-id');


        //user and permission

        Route::get('user-permission', 'SiteController@index')->name('edu-site-user-permission');
        Route::post('get-user-list', 'SiteController@getSiteUserList')->name('edu-site-get-user-list');
        Route::get('get-assigned-permission-list/{id}', 'SiteController@getAssignedListForUser')->name('edu-site-get-assigned-permission');


        Route::group(['namespace' => 'Routine', 'prefix' => 'routine'], function () {
            Route::get('master', 'RoutineController@master')->name('edu-site-routine-master');
        });

        Route::get('student-online-payment-recovery', 'SiteOnlinePaymentRecoveryController@index')->name('edu-student-online-payment-recovery');
        Route::post('get-student-transection-token-list', 'SiteOnlinePaymentRecoveryController@getStudentTransactionTokenList')->name('get-student-transection-token-list');
        Route::post('verify-student-transection-token', 'SiteOnlinePaymentRecoveryController@verifyStudentTransactionToken')->name('verify-student-transection-token');
        Route::post('update-student-fee', 'SiteOnlinePaymentRecoveryController@updateStudentFee')->name('update-student-fee');

        Route::post('get-edu-student-payemnt-list', 'SiteOnlinePaymentRecoveryController@getEduStudentPaymentList')->name('get-edu-student-payemnt-list');
        Route::post('get-edu-student-fee-generated-list', 'SiteOnlinePaymentRecoveryController@getEduStudentFeeList')->name('get-edu-student-fee-generated-list');
        Route::post('recovery-student-fee-subhead', 'SiteOnlinePaymentRecoveryController@recoveryStudentFeeSubhead')->name('recovery-student-fee-subhead');
        Route::post('edu-student-fee-generated-update', 'SiteOnlinePaymentRecoveryController@eduStudentGeneratedFeeUpdate')->name('edu-student-fee-generated-update');

        Route::post('edu-student-fee-generated-check-and-delete', 'SiteOnlinePaymentRecoveryController@eduStudentGeneratedFeeCheckAndDelete')->name('edu-student-fee-generated-check-and-delete');

        // admission fee recovery
        Route::get('online-admission-payment-recovery', 'SiteOnlinePaymentRecoveryController@index')->name('edu-online-admission-payment-recovery');
        Route::post('get-admission-transection-token-list', 'SiteOnlinePaymentRecoveryController@getAdmissionTransactionTokenList')->name('edu-get-admission-transection-token-list');
        Route::post('verify-admission-transection-token', 'SiteOnlinePaymentRecoveryController@verifyAdmissionTransactionToken')->name('edu-verify-admission-transection-token');
        Route::post('update-admission-fee', 'SiteOnlinePaymentRecoveryController@updateAdmissionFee')->name('edu-update-admission-fee');


    });


    Route::group(['namespace' => 'Role', 'prefix' => 'role'], function () {

        Route::get('list', 'RoleController@index')->name('edu-role-list');
        Route::get('add', 'RoleController@create')->name('edu-role-add-form');
        Route::get('assign', 'RoleController@roleAssignForm')->name('edu-role-assign-form');
        Route::post('assign', 'RoleController@assignRole')->name('edu-role-assign');
        Route::get('edit/{id}', 'RoleController@editRoleForm')->name('edu-role-edit-form');
        Route::get('view/{id}', 'RoleController@viewRole')->name('edu-role-view');

        //API
        Route::get('get-role-full-list', 'RoleController@getFullRoleList')->name('edu-role-get-full-role-list');
        Route::get('get-roles-with-paginate', 'RoleController@getRolesWithPaginate')->name('edu-role-get-role-list-with-paginate');
        Route::post('add', 'RoleController@store')->name('edu-role-create');
        Route::get('delete/{id}', 'RoleController@deleteRole')->name('edu-role-delete');
        Route::put('edit/{id}', 'RoleController@update')->name('edu-role-update');

    });

    Route::group(['namespace' => 'EduUser', 'prefix' => 'user'], function () {

        Route::get('list', 'EduUserController@index')->name('edu-user-list');
        Route::post('add', 'EduUserController@eduUserStore')->name('edu-user-store');
        Route::put('edit/{id}', 'EduUserController@update')->name('edu-user-edit');

        //Api
        Route::get('get-edu-user-list', 'EduUserController@eduUserList')->name('edu-user-get-edu-user-list');
        Route::get('get-edu-user-list-with-pagination', 'EduUserController@eduUserListWithPagination')->name('edu-user-get-edu-user-list-with-pagination');
        Route::get('get-edu-user-list-and-role-list', 'EduUserController@getEduUserListAndRoleList')->name('edu-user-get-edu-user-list-and-role-list');
        Route::get('get-site-list-depends-on-site-group/{id}', 'EduUserController@getSiteListDependsOnSiteGroup')->name('edu-user-get-site-list-depends-on-site-group');


    });

    Route::group(['namespace' => 'Permission', 'prefix' => 'permission'], function () {

        Route::get('assign', 'PermissionController@assignPermissionForm')->name('edu-user-permission-assign-permission-form');
        Route::get('get-assigned-list/{id}', 'PermissionController@getAssignedListForSite')->name('edu-user-permission-get-assigned-list');
        Route::post('assign-sub-module-to-user', 'PermissionController@assignSubModuleToUser')->name('edu-assign-sub-module-to-user');


        //assign extra permission
        Route::get('edu-user-assign-extra-permission', 'AssignExtraPermissionController@assignExtraPermissionForm')->name('edu-user-permission-assign-extra-permission-form');
        Route::get('edu-user-get-assigned-extra-module-list/{id}', 'AssignExtraPermissionController@getAssignedListForEduUser')->name('edu-user-permission-get-assigned-extra-list');
        Route::post('assign-extra-module-to-edu-user', 'AssignExtraPermissionController@assignSubModuleToEduUser')->name('edu-assign-extra-module-permission-to-edu-user');
    });

    Route::group(['namespace' => 'Item', 'prefix' => 'item'], function () {
        Route::get('get-item-list/{category?}', 'ItemDetailsController@getItemList')->name('edu-item-get-item-list');

    });

    Route::group(['namespace' => 'HelpDesk', 'prefix' => 'help-desk'], function () {
        Route::get('site-help-desk-setting-form', 'EduSiteHelpDeskSettingController@index')->name('site-help-desk-setting-form');
        Route::get('get-edu-site-help-desk-menu-list', 'EduSiteHelpDeskSettingController@getEduSiteHelpDeskMenuList')->name('get-edu-site-help-desk-menu-list');
        Route::post('add-edu-site-help-desk-menu', 'EduSiteHelpDeskSettingController@addEduSiteHelpDeskMenu')->name('add-edu-site-help-desk-menu');
        Route::put('update-edu-site-help-desk-menu/{id}', 'EduSiteHelpDeskSettingController@updateEduSiteHelpDeskMenu')->name('update-edu-site-help-desk-menu');
        Route::delete('delete-edu-site-help-desk-menu/{id}', 'EduSiteHelpDeskSettingController@deleteEduSiteHelpDeskMenu')->name('delete-edu-site-help-desk-menu');

    });

    Route::group(['namespace' => 'HelpDesk', 'prefix' => 'help-desk-setting'], function () {
        Route::get('get-help-desk-menu-site-group-role-list', 'EduSiteHelpDeskSettingController@getHelpDeskMenuSiteGroupRoleList')->name('get-help-desk-menu-site-group-role-list');
        Route::post('create-help-desk-menu-site-group-role', 'EduSiteHelpDeskSettingController@createHelpDeskMenuSiteGroupRole')->name('create-help-desk-menu-site-group-role');
        Route::post('get-help-desk-setting-list', 'EduSiteHelpDeskSettingController@getHelpDeskSettingList')->name('get-help-desk-setting-list');
        Route::post('update-help-desk-setting', 'EduSiteHelpDeskSettingController@updateHelpDeskSetting')->name('update-help-desk-setting');

    });

    Route::group(['namespace' => 'Replication', 'prefix' => 'replication'], function () {
        Route::get('get-site-replication-master-form', 'SiteReplicationController@index')->name('get-site-replication-master-form');
        Route::post('get-year-site-list-for-replication', 'SiteReplicationController@getYearSiteListForReplication')->name('get-year-site-list-for-replication');
        Route::post('get-from-site-year-group-base-dept-class-list-for-replication', 'SiteReplicationController@getFromSiteYearGroupBaseDeptClassListForReplication')->name('get-from-site-year-group-base-dept-class-list-for-replication');
        Route::post('get-to-site-year-group-base-dept-class-list-for-replication', 'SiteReplicationController@getToSiteYearGroupBaseDeptClassListForReplication')->name('get-to-site-year-group-base-dept-class-list-for-replication');
        Route::post('create-site-subject-condition-replication', 'SiteReplicationController@createSiteSubjectConditionReplication')->name('create-site-subject-condition-replication');

    });


    Route::group(['namespace' => 'Site', 'prefix' => 'site-membership'], function () {
        Route::get('list', 'SiteMembershipController@index')->name('site-membership-list');
        Route::get('get-membership-details-by-site/{id}', 'SiteMembershipController@getMembershipDetailsBySite')->name('edu-site-get-membership-details-by-site');
        Route::post('add', 'SiteMembershipController@createSiteMembership')->name('site-membership-create');
        // Route::get('edit/{id}', ['as' => 'site-membership-edit-form', 'uses' => 'SiteMembershipController@editSiteMembershipForm']);
        Route::post('edit/{id?}', 'SiteMembershipController@saveOrUpdateMembership')->name('site-membership-add-or-update');
        Route::get('web-menu/{site_id?}', 'SiteMembershipController@saveOrUpdateWebMenu')->name('site-membership-add-or-update-web-menu');
    });

    Route::group(['namespace' => 'Site', 'prefix' => 'site-membership'], function () {
        Route::get('list', 'SiteOnlinePaymentRecoveryController@index')->name('site-membership-list');
    });
    Route::group(['namespace' => 'SitePayment', 'prefix' => 'challan'], function () {
        Route::get('master', 'SiteChallanController@index')->name('edu-challan-master');
        Route::get('create', 'SiteChallanController@index')->name('edu-challan-master');
        Route::get('edit/{id}', 'SiteChallanController@index')->name('edu-challan-edit');
        Route::post('update', 'SiteChallanController@update')->name('edu-site-challan-update');
        Route::post('create', 'SiteChallanController@create')->name('edu-challan-create-master');
        Route::get('get-list', 'SiteChallanController@getChallanList')->name('edu-site-challan-get-challan-list');
        Route::get('get-challan-details/{id}', 'SiteChallanController@getChallanDetailsForPayment')->name('edu-site-challan-get-the-challan-details-for-payment');


        Route::get('pdf-report/{id}', 'SiteChallanController@getChallanPdfReport')->name('edu-site-challan-get-pdf-report');
        Route::get('delete/{id}', 'SiteChallanController@deleteSiteChallan')->name('edu-site-challan-delete');
    });

    Route::group(['namespace' => 'SitePayment', 'prefix' => 'reguler-site'], function () {
        Route::get('master', 'SiteChallanController@index')->name('edu-site-regular-site-invoice-list');
        Route::get('master2', 'SiteChallanController@index')->name('edu-site-regular-site-head-wise-report-list');
        // Route::get('create', 'SiteChallanController@index')->name('edu-challan-master');
        // Route::get('edit/{id}', 'SiteChallanController@index')->name('edu-challan-edit');
        // Route::post('update', 'SiteChallanController@update')->name('edu-site-challan-update');
        // Route::post('create', 'SiteChallanController@create')->name('edu-challan-create-master');
        // Route::get('get-list', 'SiteChallanController@getChallanList')->name('edu-site-challan-get-challan-list');
        // Route::get('get-challan-details/{id}', 'SiteChallanController@getChallanDetailsForPayment')->name('edu-site-challan-get-the-challan-details-for-payment');


        // Route::get('pdf-report/{id}', 'SiteChallanController@getChallanPdfReport')->name('edu-site-challan-get-pdf-report');
        // Route::get('delete/{id}', 'SiteChallanController@deleteSiteChallan')->name('edu-site-challan-delete');
    });


    Route::group(['namespace' => 'SitePayment', 'prefix' => 'invoice'], function () {
        Route::get('master', 'SiteInvoiceController@index')->name('edu-invoice-master');

        Route::get('create', 'SiteInvoiceController@index')->name('edu-site-invoice-create');
        Route::post('create', 'SiteInvoiceController@create')->name('edu-site-invoice-create');
        Route::get('edit/{id}', 'SiteInvoiceController@index')->name('edu-invoice-edit');
        Route::post('update', 'SiteInvoiceController@update')->name('edu-site-invoice-update');
        Route::get('delete/{id}', 'SiteInvoiceController@deleteSiteInvoice')->name('edu-site-invoice-delete');

        Route::get('get-list', 'SiteInvoiceController@getInvoiceList')->name('edu-site-invoice-get-invoice-list');
        Route::post('get-list-by-site', 'SiteInvoiceController@getInvoiceListBySite')->name('edu-site-invoice-get-invoice-list-by-site');
        Route::get('get-invoice-details/{id}', 'SiteInvoiceController@getInvoiceDetailsForPayment')->name('edu-site-invoice-get-the-invoice-details-for-payment');
        Route::get('get-data-for-new-invoice-by-site/{type}/{site}', 'SiteInvoiceController@getDataForNewInvoiceBySite')->name('edu-site-invoice-get-data-for-new-invoice-by-site');
        Route::post('get-invoice-by-search', 'SiteInvoiceController@getInvoiceBySearch')->name('edu-site-invoice-get-invoice-by-search');

        Route::get('get-reguler-site-invoice-list', 'SiteInvoiceController@getRegulerSiteInvoiceList')->name('edu-site-invoice-get-invoice-list');
        Route::get('get-reguler-site-head-wise-report-list', 'SiteInvoiceController@getRegulerSiteHeadWiseReportList')->name('edu-site-invoice-get-invoice-list');
        Route::get('get-reguler-site-head-wise-report-list-pdf', 'SiteInvoiceController@getRegulerSiteHeadWiseReportListPdf')->name('get-reguler-site-head-wise-report-list-pdf');
        Route::get('open-report-pdf/{name}', 'SiteInvoiceController@openReportPdf')->name('open-report-pdf');
        Route::get('reguler-site-list', 'SiteInvoiceController@regulerSiteList')->name('reguler-site-list');
        Route::post('reguler-site-multiple-invoice-create', 'SiteInvoiceController@createRegulerSiteInvoiceCreate')->name('reguler-site-multiple-invoice-create');

        //report
        Route::get('pdf-report/{id}', 'SiteInvoiceController@getInvoicePdfReport')->name('edu-site-invoice-get-pdf-report');


        Route::group(['prefix' => 'payment'], function () {

            Route::post('create-payment', 'SitePaymentController@createPayment')->name('edu-site-invoice-payment-create');
            Route::get('details/{id}', 'SitePaymentController@getInvoicePayments')->name('edu-site-invoice-payment-details');
            Route::patch('edit/{id}', 'SitePaymentController@editSiteAmountReceive')->name('site-amount-receive-edit');
            Route::get('delete/{id}', 'SitePaymentController@deleteSiteAmountReceive')->name('site-amount-receive-delete');


            //API-----------
            Route::get('get-payments-for-site', 'SitePaymentController@getSitePayments')->name('site-invoice-payment-payment-list-for-site');


        });

    });


    Route::group(['namespace' => 'PaymentGateway', 'prefix' => 'payment-gateway'], function () {
        Route::get('view', 'PaymentGatewayController@index')->name('edu-payment-gateway');
        Route::get('list', 'PaymentGatewayController@getPaymentGatewayList')->name('edu-payment-gateway-list');
        Route::get('list-with-pagination', 'PaymentGatewayController@getPaymentGatewayListWithPagination')->name('edu-payment-gateway-list-with-pagination');

        Route::post('add', 'PaymentGatewayController@create')->name('edu-payment-gateway-create');
        Route::post('update', 'PaymentGatewayController@update')->name('edu-payment-gateway-update');
        Route::delete('delete/{id}', 'PaymentGatewayController@delete')->name('edu-payment-gateway-delete');

//        Route::get('payment-type-list', 'PaymentGatewayController@getPaymentGatewayPaymentTypeList')->name('edu-payment-gateway-payment-type-list');
//        Route::get('payment-method-list/{key}', 'PaymentGatewayController@getPaymentGatewayPaymentMethodList')->name('edu-payment-gateway-payment-method-list-by-payment-type-key');
//        Route::get('payment-marchent-type-list/{key}', 'PaymentGatewayController@getPaymentGatewayPaymentMarchentTypeList')->name('edu-payment-gateway-payment-marchent-type-list-by-payment-method-key');


    });

    Route::group(['namespace' => 'PaymentGateway', 'prefix' => 'payment-gateway'], function () {

        Route::group(['prefix' => 'academic-payment-type'], function () {
            Route::get('view', 'AcademicPaymentTypeController@index')->name('edu-payment-gateway-academic-payment-type-view');
            Route::get('list', 'AcademicPaymentTypeController@getAcademicPaymentTypeList')->name('edu-payment-gateway-academic-payment-type-list');
            Route::get('list-with-pagination', 'AcademicPaymentTypeController@getAcademicPaymentTypeListWithPagination')->name('edu-payment-gateway-academic-payment-type-list-with-pagination');

            Route::post('add', 'AcademicPaymentTypeController@create')->name('edu-payment-gateway-academic-payment-type-create');
            Route::post('update', 'AcademicPaymentTypeController@update')->name('edu-payment-gateway-academic-payment-type-update');
            Route::delete('delete/{id}', 'AcademicPaymentTypeController@delete')->name('edu-payment-gateway-academic-payment-type-delete');
        });

        Route::group(['prefix' => 'academic-online-payment-method'], function () {
            Route::get('view', 'AcademicOnlinePaymentMethodController@index')->name('edu-payment-gateway-academic-online-payment-method-view');
            Route::get('list', 'AcademicOnlinePaymentMethodController@getAcademicOnlinePaymentMethodList')->name('edu-payment-gateway-academic-online-payment-method-list');
            Route::get('list-with-pagination', 'AcademicOnlinePaymentMethodController@getAcademicOnlinePaymentMethodListWithPagination')->name('edu-payment-gateway-academic-online-payment-method-list-with-pagination');

            Route::post('add', 'AcademicOnlinePaymentMethodController@create')->name('edu-payment-gateway-academic-online-payment-method-create');
            Route::post('update', 'AcademicOnlinePaymentMethodController@update')->name('edu-payment-gateway-academic-online-payment-method-update');
            Route::delete('delete/{id}', 'AcademicOnlinePaymentMethodController@delete')->name('edu-payment-gateway-academic-online-payment-method-delete');
        });

        Route::group(['prefix' => 'academic-online-payment-marchent-type'], function () {
            Route::get('view', 'AcademicOnlinePaymentMarchentTypeController@index')->name('edu-payment-gateway-academic-online-payment-marchent-type-view');
            Route::get('list', 'AcademicOnlinePaymentMarchentTypeController@getAcademicOnlinePaymentMarchentTypeList')->name('edu-payment-gateway-academic-online-payment-marchent-type-list');
            Route::get('list-with-pagination', 'AcademicOnlinePaymentMarchentTypeController@getAcademicOnlinePaymentMarchentTypeListWithPagination')->name('edu-payment-gateway-academic-online-payment-marchent-type-list-with-pagination');

            Route::post('add', 'AcademicOnlinePaymentMarchentTypeController@create')->name('edu-payment-gateway-academic-online-payment-marchent-type-create');
            Route::post('update', 'AcademicOnlinePaymentMarchentTypeController@update')->name('edu-payment-gateway-academic-online-payment-marchent-type-update');
            Route::delete('delete/{id}', 'AcademicOnlinePaymentMarchentTypeController@delete')->name('edu-payment-gateway-academic-online-payment-marchent-type-delete');
        });

    });
});


//all academic routes    ================================

Route::group(['namespace' => 'AcademicAll', 'prefix' => 'academic'], function () {



    Route::group(['prefix' => 'class'], function () {
        Route::get('list', 'AcademicClassController@index')->name('class-list');
        Route::get('get-academic-class-list', 'AcademicClassController@getClassList')->name('academic-class-get-academic-class-list');
        Route::get('get-academic-class-list-by-siteid', 'AcademicClassController@getClassListBySiteID')->name('academic-class-get-academic-class-list-by-siteid');
        Route::get('get-academic-class-list-with-pagination', 'AcademicClassController@getClassWithPagination')->name('academic-class-get-academic-class-list-with-pagination');

        Route::get('new', 'AcademicClassController@createClassForm')->name('class-add-form');
        Route::post('add', ['as' => 'class-create', 'uses' => 'AcademicClassController@createClass']);
        Route::get('edit/{id}', ['as' => 'class-edit-form', 'uses' => 'AcademicClassController@editClassForm']);
        Route::post('update', ['as' => 'class-edit', 'uses' => 'AcademicClassController@editClass']);
        Route::get('delete/{id}', ['as' => 'class-delete', 'uses' => 'AcademicClassController@deleteClass']);


        Route::get('get-site-class-list', 'AcademicClassController@siteBaseClassList')->name('site-class-list');

        Route::get('abc/{classId}', ['as' => 'class-section', 'uses' => 'AcademicClassController@sectionOfClass']);

    });

    Route::group(['prefix' => 'shift'], function () {
        Route::get('get-shift-list-by-site-id/{site_id}', 'AcademicShiftController@getSiteShiftListBySiteSessionId')->name('academic-shift-get-shift-list-by-site-id');
    });


    Route::group(['prefix' => 'session'], function () {
        Route::get('get-all-category-academic-session-list', 'AcademicSessionController@academicSessionList')->name('get-all-category-academic-session-list');

        Route::get('new', 'AcademicSessionController@createSessionForm')->name('session-add-form');
        Route::post('add', 'AcademicSessionController@createSession')->name('session-add');
        Route::get('get-academic-session-list-with-pagination', 'AcademicSessionController@getSessionWithPagination')->name('get-list-with-pagination');
        Route::get('list', 'AcademicSessionController@index')->name('academic-session-list-with-pagination-view');

        Route::get('edit/{id}', ['as' => 'session-edit-form', 'uses' => 'AcademicSessionController@editSessionForm']);
        Route::post('update', ['as' => 'session-edit', 'uses' => 'AcademicSessionController@updateSession']);

    });


    Route::group(['prefix' => 'waiver-type'], function () {

        Route::get('view', 'AcademicWaiverTypeController@index')->name('academic-waiver-type-view');
        Route::get('list', 'AcademicWaiverTypeController@getAcademicWaiverTypeList')->name('academic-waiver-type-list');
        Route::post('add', 'AcademicWaiverTypeController@store')->name('academic-waiver-type-add');
        Route::post('edit/{id}', 'AcademicWaiverTypeController@update')->name('academic-waiver-type-edit');
        Route::delete('delete/{id}', 'AcademicWaiverTypeController@destroy')->name('academic-waiver-type-delete');

    });

    Route::group(['prefix' => 'student-offer-type'], function () {

        Route::get('view', 'AcademicStudentOfferTypeController@index')->name('academic-student-offer-type-view');
        Route::get('list', 'AcademicStudentOfferTypeController@getAcademicStudentOfferTypeList')->name('academic-student-offer-type-list');
        Route::post('add', 'AcademicStudentOfferTypeController@store')->name('academic-student-offer-type-add');
        Route::post('edit/{id}', 'AcademicStudentOfferTypeController@update')->name('academic-student-offer-type-edit');
        Route::delete('delete/{id}', 'AcademicStudentOfferTypeController@destroy')->name('academic-student-offer-type-delete');

    });

    Route::group(['prefix' => 'month-name'], function () {
        Route::post('index', 'AcademicMonthNameController@index')->name('academic-month-view');
        Route::post('list', 'AcademicMonthNameController@getMonthList')->name('academic-month-list');
        Route::delete('delete/{id}', 'AcademicMonthNameController@deleteSessionTypeSetting')->name('site-academic-session-type-delete-setting');
    });

    Route::group(['prefix' => 'group'], function () {
        Route::get('list', 'AcademicGroupController@index')->name('academic-group-add-form');
        Route::post('add', 'AcademicGroupController@store')->name('academic-group-create');
        Route::post('update', 'AcademicGroupController@update')->name('academic-group-edit');
        Route::get('get-academic-group-list', 'AcademicGroupController@getGroupList')->name('academic-group-get-academic-group-list');
        Route::get('get-academic-group-by-site-group/{id}', 'AcademicGroupController@getAcademicGroupsBySiteGroup')->name('academic-group-get-academic-group-by-site-group');
    });


    Route::group(['prefix' => 'group-based-detail'], function () {
        Route::get('list', 'GroupBaseDetailController@create')->name('group-base-detail-add-form');
        Route::get('get-group-list', 'GroupBaseDetailController@getAcademicGroupList')->name('load-academic-group-list');
        Route::get('get-group-based-class-section-group-subject-condition/{id}', 'GroupBaseDetailController@getAcademicGroupBasedClassSectionGroupSubjectCondition')->name('academic-group-based-detail-get-group-based-class-section-group-subject-condition');
        Route::post('insert-group-base-detail', 'GroupBaseDetailController@store')->name('group-base-detail-create');

    });



    Route::group(['prefix' => 'student-admission-type'], function () {
        Route::get('get-student-admission-type-list', 'AcademicAdmissionTypeController@admissionTypeList')->name('get-student-admission-type-list');
    });
    Route::group(['prefix' => 'occupation'], function () {
        Route::get('get-occupation-list', 'AcademicOccupationController@occupationList')->name('get-occupation-list');
    });
    Route::group(['prefix' => 'student-quata'], function () {
        Route::get('get-student-quata-list', 'AcademicStudentQuataController@quataList')->name('get-student-quata-list');
    });
    Route::group(['prefix' => 'student-type'], function () {
        Route::get('get-site-base-student-type-list', 'AcademicStudentTypeController@siteBaseStudentTypeList')->name('get-site-base-student-type-list');
    });
    Route::group(['prefix' => 'version'], function () {
        Route::get('get-site-base-version-list', 'AcademicVersionController@siteBaseVersionList')->name('get-site-base-version-list');
    });


    Route::group(['prefix' => 'student-category'], function () {
        Route::get('get-site-base-student-category-list', 'AcademicStudentCategoryController@siteBaseStudentCategory')
            ->name('site-base-student-category-list');
    });


    Route::group(['prefix' => 'designation'], function () {

        Route::get('list', ['as' => 'designation-list', 'uses' => 'DesignationController@index']);
        Route::get('get-designation-list', 'DesignationController@getDesignationList')->name('academic-designation-get-designation-list');

        Route::get('add', ['as' => 'designation-add-form', 'uses' => 'DesignationController@createDesignationForm']);
        Route::post('add', ['as' => 'designation-add', 'uses' => 'DesignationController@createDesignation']);
        Route::get('edit/{id}', ['as' => 'designation-edit-form', 'uses' => 'DesignationController@editDesignationForm']);
        Route::put('update', ['as' => 'designation-edit', 'uses' => 'DesignationController@editDesignation']);
        Route::get('delete/{id}', ['as' => 'designation-delete', 'uses' => 'DesignationController@deleteDesignation']);
        Route::get('{deptId}', ['as' => 'designation-dept', 'uses' => 'DesignationController@designationOfDept']);
        Route::get('user/{userId}', ['as' => 'designation-user', 'uses' => 'DesignationController@designationToEdit']);

    });

    Route::group(['prefix' => 'house'], function () {

        Route::get('list', ['as' => 'house-list', 'uses' => 'HouseController@index']);
        Route::get('get-house-list', 'HouseController@getHouseList')->name('academic-house-get-house-list');

        Route::get('add', ['as' => 'house-add-form', 'uses' => 'HouseController@createHouseForm'])->name('add-house-name');
        Route::post('add', ['as' => 'house-add', 'uses' => 'HouseController@createHouse'])->name('create-house');
        Route::get('edit/{id}', ['as' => 'house-edit-form', 'uses' => 'HouseController@editHouseForm'])->name('edit-house-name');
        Route::put('update', ['as' => 'house-edit', 'uses' => 'HouseController@editHouse'])->name('update-house-name');
        Route::get('delete/{id}', ['as' => 'house-delete', 'uses' => 'HouseController@deleteHouse'])->name('delete-house-name');
        Route::get('{deptId}', ['as' => 'house-dept', 'uses' => 'HouseController@houseOfDept'])->name('house-of-dept');
        Route::get('user/{userId}', ['as' => 'house-user', 'uses' => 'HouseController@houseToEdit'])->name('house-user-to-edit');

    });

    Route::group(['prefix' => 'year'], function () {
        Route::get('list', 'AcademicYearController@create')->name('academic-year-add-form');
        Route::post('add', 'AcademicYearController@store')->name('academic-year-create');
        Route::get('edit/{id}', 'AcademicYearController@edit')->name('academic-year-edit-form');
        Route::put('update', 'AcademicYearController@update')->name('academic-year-edit');
        Route::get('delete/{id}', 'AcademicYearController@destroy')->name('academic-year-delete');
        Route::get('activate/{id}', 'AcademicYearController@active_inactive')->name('academic-year-activeinactive');

        Route::get('academic-year-list', 'AcademicYearController@academicYearList')->name('get-all-type-academic-year-list');
        Route::get('academic-year-list-by-site-id/{s_id}/{acc_group_id}', 'AcademicYearController@academicYearListBySiteId')->name('get-all-type-academic-year-list-by-site-id');
    });

    Route::group(['prefix' => 'fiscal-year'], function () {
        Route::get('list', 'AcademicFiscalYearController@create')->name('academic-fiscal-year-add-form');
        Route::post('add', 'AcademicFiscalYearController@store')->name('academic-fiscal-year-create');
        Route::get('edit/{id}', 'AcademicFiscalYearController@edit')->name('academic-fiscal-year-edit-form');
        Route::put('update', 'AcademicFiscalYearController@update')->name('academic-fiscal-year-edit');
        Route::get('delete/{id}', 'AcademicFiscalYearController@destroy')->name('academic-fiscal-year-delete');
        Route::get('activate/{id}', 'AcademicFiscalYearController@active_inactive')->name('academic-fiscal-year-activeinactive');

         Route::get('academic-fiscal-year-list', 'AcademicFiscalYearController@academicFiscalYearList')->name('get-all-type-academic-fiscal-year-list');
        Route::get('academic-fiscal-year-list-by-site-id/{s_id}/{acc_group_id}', 'AcademicFiscalYearController@academicFiscalYearListBySiteId')->name('get-all-type-academic-year-fiscal-list-by-site-id');
    });

    Route::group(['prefix' => 'subject'], function () {
        Route::get('list', 'AcademicSubjectController@index')->name('academic-subject-list');
        Route::get('get-subject-list', 'AcademicSubjectController@getAcademicSubjectList')->name('academic-subject-get-subject-list');
        Route::get('get-subject-list-without-pagination', 'AcademicSubjectController@getAcademicSubjectListWithoutPagination')->name('academic-subject-get-subject-list-without-pagination');
        Route::get('get-class-list-with-selected-class/{id}', 'AcademicSubjectController@getAcademicClassListWithSelectedClass')->name('academic-subject-get-class-list-with-selected-class');
        Route::post('attach-class-to-subject', 'AcademicSubjectController@attachClassToSubject')->name('academic-subject-attach-class-to-subject');
        Route::post('save-subject', 'AcademicSubjectController@store')->name('academic-subject-save-subject');
        Route::put('update-subject/{id}', 'AcademicSubjectController@update')->name('academic-subject-update-subject');
        Route::delete('delete-subject/{id}', 'AcademicSubjectController@destroy')->name('academic-subject-delete-subject');
    });


    Route::group(['prefix' => 'class-group'], function () {
        Route::get('list', 'ClassGroupController@index')->name('class-group-add-form');

        Route::get('get-class-group-list', 'ClassGroupController@getList')->name('academic-class-group-get-class-group-list');


        Route::post('add', 'ClassGroupController@store')->name('class-group-create');
        Route::get('edit/{id}', 'ClassGroupController@edit')->name('class-group-edit-form');
        Route::post('edit/{id}', 'ClassGroupController@getTheGroup')->name('class-group-edit-form');
        Route::post('update', 'ClassGroupController@update')->name('class-group-edit');
        Route::get('delete/{id}', 'ClassGroupController@destroy')->name('class-group-delete');


    });

    Route::group(['prefix' => 'subject-condition'], function () {
        Route::get('list', ['as' => 'subject-condition-list', 'uses' => 'SubjectConditionController@index']);
        Route::get('add', ['as' => 'subject-condition-add-form', 'uses' => 'SubjectConditionController@createSubjectConditionForm']);
        Route::post('add', ['as' => 'subject-condition-create', 'uses' => 'SubjectConditionController@createSubjectCondition']);
        Route::get('get-subject-condition-list', 'SubjectConditionController@getAcademicSubjectConditionList')->name('academic-subject-condition-get-subject-condition-list');
        Route::get('view/{id}', ['as' => 'subject-condition-view', 'uses' => 'SubjectConditionController@viewSubjectCondition']);
//        Route::get('edit/{id}', ['as'=>'subject-condition-edit-form','uses'=>'SubjectConditionController@getSubjectConditionEditForm']);
        Route::put('edit/{id}', ['as' => 'subject-condition-edit', 'uses' => 'SubjectConditionController@editSubjectCondition']);
        Route::delete('delete/{id}', ['as' => 'subject-condition-delete', 'uses' => 'SubjectConditionController@deleteSubjectCondition']);
    });
    Route::group(['prefix' => 'academic-fee'], function () {

        //Route::get('add', ['as'=>'academic-fee-add-form','uses'=>'AcademicFeeController@createAcademicFeeForm']);
        Route::post('add', ['as' => 'academic-fee-create', 'uses' => 'AcademicFeeController@createAccademicFee']);
        Route::get('list', ['as' => 'academic-fee-list', 'uses' => 'AcademicFeeController@index']);
        Route::get('get-academic-fee-list', 'AcademicFeeController@getAccademicFeeList')->name('get-accademic-fee-list');
        Route::get('view/{id}', ['as' => 'academic-fee-view', 'uses' => 'AcademicFeeController@viewAccademicFee']);
//        Route::get('edit/{id}', ['as'=>'subject-condition-edit-form','uses'=>'SubjectConditionController@getSubjectConditionEditForm']);
        Route::post('edit/{id}', ['as' => 'academic-fee-edit', 'uses' => 'AcademicFeeController@editAccademicFee']);
        Route::delete('delete/{id}', ['as' => 'academic-fee-delete', 'uses' => 'AcademicFeeController@deleteAccademicFee']);
    });

    Route::group(['prefix' => 'academic-fee-head'], function () {

        Route::get('view', 'AcademicFeeHeadController@index')->name('get-academic-fee-head-list');
        Route::get('list', 'AcademicFeeHeadController@getFeeHeadList')->name('get-academic-fee-head-list-data');
        Route::post('add', 'AcademicFeeHeadController@store')->name('add-academic-fee-head');
        Route::post('edit/{id}', 'AcademicFeeHeadController@update')->name('edit-academic-fee-head');
        Route::delete('delete/{id}', 'AcademicFeeHeadController@destroy')->name('delete-academic-fee-head');

    });

    Route::group(['prefix' => 'academic-fee-sub-head'], function () {

        Route::get('view', 'AcademicFeeSubHeadController@index')->name('get-academic-fee-sub-head-view');
        Route::get('list', 'AcademicFeeSubHeadController@getFeeSubHeadList')->name('get-academic-fee-sub-head-list-data');
        Route::get('transport-list', 'AcademicFeeSubHeadController@getTransportList')->name('get-transport-list');
        Route::get('residence-list', 'AcademicFeeSubHeadController@getResidenceList')->name('get-residence-list');
        Route::get('gender-list', 'AcademicFeeSubHeadController@getGenderList')->name('get-gender-list');
        Route::post('add', 'AcademicFeeSubHeadController@store')->name('add-academic-fee-sub-head');
        Route::post('edit/{id}', 'AcademicFeeSubHeadController@update')->name('edit-academic-fee-sub-head');
        Route::delete('delete/{id}', 'AcademicFeeSubHeadController@destroy')->name('delete-academic-sub-fee-head');

    });

    Route::group(['prefix' => 'academic-fee-group'], function () {

        Route::get('view', 'AcademicFeeGroupController@index')->name('get-academic-fee-group-view');
        Route::get('list', 'AcademicFeeGroupController@getFeeGroupList')->name('get-academic-fee-group-list-data');
        Route::post('add', 'AcademicFeeGroupController@store')->name('add-academic-fee-group');
        Route::post('edit/{id}', 'AcademicFeeGroupController@update')->name('edit-academic-fee-group');
        Route::delete('delete/{id}', 'AcademicFeeGroupController@destroy')->name('delete-academic-fee-group');

    });

    Route::group(['prefix' => 'academic-admission-fee-type'], function () {

        Route::get('view', 'AcademicAdmissionFeeTypeController@index')->name('academic-admission-fee-type-view');
        Route::get('list', 'AcademicAdmissionFeeTypeController@getAdmissionFeeTypeList')->name('get-academic-admission-fee-type-list-data');
        Route::post('add', 'AcademicAdmissionFeeTypeController@store')->name('add-academic-admission-fee-type');
        Route::post('edit/{id}', 'AcademicAdmissionFeeTypeController@update')->name('edit-academic-admission-fee-type');
        Route::delete('delete/{id}', 'AcademicAdmissionFeeTypeController@destroy')->name('delete-academic-admission-fee-type');

    });

    Route::group(['prefix' => 'section'], function () {
        Route::get('list', 'AcademicSectionController@index')->name('academic-section-list');
        Route::get('get-section-list', 'AcademicSectionController@getAcademicSubjectConditionList')->name('academic-section-get-section-list');
        Route::get('get-section-list/{id}', 'AcademicSectionController@getAcademicClassSectionList')->name('academic-section-get-section-list-by-classid');
        //Route::get('get-subject-group-condition-setting-list', 'SubjectGroupConditionSettingController@getSubjectGroupConditionSettingList')->name('subject-group-condition-setting-list');
        Route::post('save-section', 'AcademicSectionController@store')->name('academic-section-save-section');
        Route::put('update-section/{id}', 'AcademicSectionController@update')->name('academic-section-update-section');
        Route::delete('delete-section/{id}', 'AcademicSectionController@destroy')->name('academic-section-delete-section');


//        Route::get('get-site-class-base-section/{class_id}/{shift_id}/{class_group_id}', 'AcademicSectionController@siteClassBaseSection')
//            ->name('site-class-shift-group-base-section');
    });

    Route::group(['prefix' => 'academic-session-type'], function () {
        Route::get('list', 'AcademicSessionTypeController@index')->name('academic-session-type-view');

        Route::get('get-academic-session-type-list', 'AcademicSessionTypeController@getAcademicSessionTypeList')->name('get-academic-session-type-list');
        Route::put('edit/{id}', 'AcademicSessionTypeController@update')->name('academic-session-type-edit');
        Route::post('add', 'AcademicSessionTypeController@store')->name('site-class-similarity-add');
        Route::delete('delete/{id}', 'AcademicSessionTypeController@destroy')->name('site-class-similarity-delete');

    });


});

    Route::group(['namespace' => 'Assessment', 'prefix' => 'assessment'], function () {

        Route::group(['namespace' => 'Setting', 'prefix' => 'setting'], function () {
            Route::get('assessment-setting-master', 'AcademicAssessmentTypeNoController@index')->name('academic-assessment-setting-form');
            Route::post('get-assessment-type-and-class-list', 'AcademicAssessmentTypeNoController@getAssessmentTypeAndClassList');
            Route::post('add', 'AcademicAssessmentTypeNoController@assessmentTypeNoAdd');
            Route::get('/list', 'AcademicAssessmentTypeNoController@assessmentTypeNoList');
            Route::put('/edit/{id}', 'AcademicAssessmentTypeNoController@assessmentTypeNoUpdate');

            Route::get('assessment-expertise-list-form', 'AcademicAssessmentExpertiseController@index')->name('academic-assessment-expertise-list-form');
            Route::post('expertis-add', 'AcademicAssessmentExpertiseController@assessmentExpertiseAdd');
            Route::get('/expertis-list', 'AcademicAssessmentExpertiseController@assessmentExpertiseList');
            Route::put('/expertis-edit/{id}', 'AcademicAssessmentExpertiseController@assessmentExpertiseUpdate');

            Route::post('class-wise-expertise-subject', 'AcademicAssessmentTopicController@classWiseExpertiseSubject');
            Route::post('add-expertis-wise-topic', 'AcademicAssessmentTopicController@createExpertiseWiseTopic');
            Route::get('/expertis-wise-topic-list', 'AcademicAssessmentTopicController@expertiseWiseTopicList');
            Route::put('/update-expertis-wise-topic/{id}', 'AcademicAssessmentTopicController@expertiseWiseTopicUpdate');

            Route::get('get-year-class-and-assessment-list', 'AcademicAssessmentAndTypeNoSettingController@getYearClassAndAssessmentList')->name('get-year-class-and-assessment-list');
            Route::post('get-subject-assessment-expertise-and-type-setup', 'AcademicAssessmentAndTypeNoSettingController@getSubjectAssessmentExpertiseAndTypeSetup')->name('get-subject-assessment-expertise-and-type-setup');
            Route::post('submit-subject-assessment-expertise-and-type-setup', 'AcademicAssessmentAndTypeNoSettingController@submitSubjectTopicsAssessmentAndTypeNoSetup')->name('submit-subject-assessment-expertise-and-type-setup');
        });

        Route::group(['namespace' => 'ResultSetting', 'prefix' => 'result-setting'], function () {
            Route::get('assessment-result-setting-master', 'AssessmentResultSettingController@index')->name('assessment-result-setting-master');
            Route::post('get-assessment-result-setting-list', 'AssessmentResultSettingController@getAssessmentResultSettingList')->name('get-assessment-result-setting-list');
            Route::post('cteate-update-assessment-result-setting', 'AssessmentResultSettingController@createUpdateAssessmentResultSetting')->name('cteate-update-assessment-result-setting');

            Route::post('get-assessment-result-scale-setting', 'AssessmentResultSettingController@getAssessmentResultScaleList')->name('get-assessment-result-scale-setting');
            Route::post('create-update-assessment-result-scale-setting', 'AssessmentResultSettingController@createUpdateAssessmentResultScale')->name('create-update-assessment-result-scale-setting');

        });


    });

// company routes

Route::group(['namespace' => 'Company', 'prefix' => 'company'], function () {

    Route::get('get-company-list', 'CompanyController@getCompanyList')->name('company-get-company-list');
    Route::get('get-site-group-list-for-company', 'CompanyController@getSiteGroupList')->name('company-get-site-group-list-for-company');
    Route::get('get-site-list-for-company-by-site-group/{id}', 'CompanyController@getSiteListBySiteGroup')->name('company-get-site-list-for-company-by-site-group');
    Route::get('get-assigned-list', 'CompanyController@getAssignedListForCompany')->name('company-get-assigned-list');


    Route::group(['namespace' => 'Role', 'prefix' => 'role'], function () {

        Route::get('role-list', 'RoleController@index')->name('company-role-role-list');
        Route::get('get-role-list', 'RoleController@getRoleList')->name('company-role-get-role-list');
        Route::post('add', 'RoleController@create')->name('company-role-add');
        Route::put('update/{id}', 'RoleController@update')->name('company-role-update');

    });
    Route::group(['namespace' => 'User', 'prefix' => 'user'], function () {

        Route::get('user-list', 'UserController@index')->name('company-user-user-list');
        Route::get('get-user-list', 'UserController@getBranchList')->name('company-user-get-user-list');
        Route::get('get-user-list-with-pagination', 'UserController@getUserListWithPagination')->name('company-user-get-user-list-with-pagination');

        Route::post('add', 'UserController@create')->name('company-user-add');
        Route::put('update/{id}', 'UserController@update')->name('company-user-update');

    });

    Route::group(['namespace' => 'Branch', 'prefix' => 'branch'], function () {

        Route::get('branch-list', 'BranchController@index')->name('company-branch-branch-list');
        Route::get('get-branch-list', 'BranchController@getBranchList')->name('company-branch-get-branch-list');
        Route::post('add', 'BranchController@create')->name('company-branch-add');
        Route::put('update/{id}', 'BranchController@update')->name('company-branch-update');

    });


});

Route::group(['namespace' => 'Edu', 'prefix' => 'edu'], function () {
    Route::group(['namespace' => 'ClassRoom', 'prefix' => 'class-room'], function () {
        Route::get('view', 'ClassRoomController@index')->name('edu-class-room-view');
        Route::get('list-with-pagination', 'ClassRoomController@getEduClassRoomList')->name('edu-class-room-list-with-pagination');
        Route::get('get-year-academic-group-department-class-subject-list', 'ClassRoomController@getYearAcademicGroupDepartmentClassSubjectList')->name('edu-class-room-get-year-academic-group-department-class-subject-list');
        Route::post('add', 'ClassRoomController@createEduClassRoomLesson')->name('edu-class-room-add');
        Route::get('lesson-details/{id}', 'ClassRoomController@getEduClassRoomLessonDetails')->name('edu-class-room-lessin-details');
        Route::post('update', 'ClassRoomController@updateEduClassRoomLesson')->name('edu-class-room-lesson-update');
        Route::post('delete/{id}', 'ClassRoomController@deleteClassRoom')->name('edu-class-room-lesson-delete');
    });
});

Route::group(['namespace' => 'Edu', 'prefix' => 'edu'], function () {
    Route::group(['namespace' => 'Accounts', 'prefix' => 'accounts'], function () {
        Route::group(['namespace' => 'AccountsHead', 'prefix' => 'accounts-head'], function () {
            Route::get('view', 'AccountsHeadController@index')->name('edu-accounts-accounts-head-view');
            Route::get('list-with-pagination', 'AccountsHeadController@getAccountsHeadListWithPagination')->name('edu-accounts-accounts-head-list-with-pagination');
            Route::post('add', 'AccountsHeadController@create')->name('edu-accounts-accounts-head-add');
            Route::post('update', 'AccountsHeadController@update')->name('edu-accounts-accounts-head-update');
            Route::post('delete/{id}', 'AccountsHeadController@delete')->name('edu-accounts-accounts-head-delete');
        });
        Route::group(['namespace' => 'AccountsVoucherType', 'prefix' => 'accounts-voucher-type'], function () {
            Route::get('view', 'AccountsVoucherTypeController@index')->name('edu-accounts-accounts-voucher-type-view');
            Route::get('list-with-pagination', 'AccountsVoucherTypeController@getEduAccountsVoucherTypeListWithPagination')->name('edu-accounts-accounts-voucher-type-list-with-pagination');
            Route::post('add', 'AccountsVoucherTypeController@create')->name('edu-accounts-accounts-voucher-type-add');
            Route::post('update', 'AccountsVoucherTypeController@update')->name('edu-accounts-accounts-voucher-type-update');
            Route::post('delete/{id}', 'AccountsVoucherTypeController@delete')->name('edu-accounts-accounts-voucher-type-delete');
        });

    });


    Route::group(['namespace' => 'Site\Report', 'prefix' => 'report'], function () {
        Route::get('site-report-master-form', 'SiteReportController@index')->name('site-report-master-form');
        Route::get('get-site-report-list-with-pagination', 'SiteReportController@getSiteReportListWithPagination')->name('get-site-report-list-with-pagination');
    });


    Route::group(['namespace' => 'Site\Invoice', 'prefix' => 'invoice'], function () {
        Route::get('site-invoice-master-form', 'SiteStudentInvoiceDeclareController@index')->name('site-invoice-master-form');
        Route::post('get-site-academic-group-list', 'SiteStudentInvoiceDeclareController@getSiteAcademicGroupList')->name('get-site-academic-group-list');
        Route::post('create-edu-site-student-invoice-declare', 'SiteStudentInvoiceDeclareController@createEduSiteStudentInvoiceDeclare')->name('create-edu-site-student-invoice-declare');
        Route::post('get-academic-group-base-invoice-declare-list', 'SiteStudentInvoiceDeclareController@getAcademicGroupBaseInvoiceDeclareList')->name('get-academic-group-base-invoice-declare-list');
        Route::post('update-edu-site-student-invoice-declare', 'SiteStudentInvoiceDeclareController@updateEduSiteStudentInvoiceDeclare')->name('update-edu-site-student-invoice-declare');
        Route::post('pause-edu-site-student-invoice-declare', 'SiteStudentInvoiceDeclareController@pauseEduSiteStudentInvoiceDeclare')->name('pause-edu-site-student-invoice-declare');
        Route::post('activate-edu-site-student-invoice-declare', 'SiteStudentInvoiceDeclareController@activateEduSiteStudentInvoiceDeclare')->name('activate-edu-site-student-invoice-declare');


    });


    Route::group(['namespace' => 'NonSite', 'prefix' => 'non-site'], function () {
        Route::get('non-site-entry-form', 'NonSiteEntryController@index')->name('non-site-entry-form');
        Route::post('new-institute-entry-excel-file-upload', 'NonSiteEntryController@newInstituteEntryExcelFileUpload')->name('new-institute-entry-excel-file-upload');
        Route::get('get-academic-group-division-district-thana-list-for-non-institute', 'NonSiteEntryController@getAcademicGroupDivisionDistrictThanaList')->name('get-academic-group-division-district-thana-list-for-non-institute');
        Route::post('get-non-site-institute-list', 'NonSiteEntryController@getNonSiteInstituteList')->name('get-non-site-institute-list');
        Route::post('get-non-site-institute-list-pdf', 'NonSiteEntryController@getNonSiteInstituteListPdf')->name('get-non-site-institute-list-pdf');
        Route::post('create-non-site-institute-info', 'NonSiteEntryController@createNonSiteInstituteInfo')->name('create-non-site-institute-info');
        Route::post('update-non-site-institute-info', 'NonSiteEntryController@updateNonSiteInstituteInfo')->name('update-non-site-institute-info');
        Route::post('delete-non-site-institute-info', 'NonSiteEntryController@deleteNonSiteInstituteInfo')->name('delete-non-site-institute-info');

    });


    Route::group(['namespace' => 'Sms', 'prefix' => 'sms'], function () {
        Route::post('create-edu-sms', 'EduSmsController@createSms')->name('create-edu-sms');
        Route::put('update-edu-sms', 'EduSmsController@update')->name('update-edu-sms');
        Route::get('get-edu-sms', 'EduSmsController@getListWithPagination')->name('get-edu-sms');
        Route::get('delete-edu-sms/{id}', 'EduSmsController@delete')->name('delete-edu-sms');

        Route::post('send-conbine-sms-to-institute', 'EduSmsController@sendToInstitute')->name('send-conbine-sms-to-institute');
        Route::post('group-get-employee-students', 'EduSmsController@groupGetEmployeeStudents')->name('group-get-employee-students');

    });


    Route::group(['namespace' => 'FileManager', 'prefix' => 'file-manager'], function () {
        Route::post('save-edu-non-site-file', 'EduNonSiteFileManagerController@saveEduNonSiteFile')->name('save-edu-non-site-file');
        Route::get('get-edu-non-site-file', 'EduNonSiteFileManagerController@getEduNonSiteFile')->name('get-edu-non-site-file');

    });

    Route::group(['namespace' => 'Email', 'prefix' => 'email'], function () {
        Route::post('create-update-webmail-document-list', 'EduEmailManagementController@createUpdateWebmailDocumentList')->name('create-update-webmail-document-list');
        Route::get('get-created-email-list', 'EduEmailManagementController@getCreatedEmailList')->name('get-created-email-list');
        Route::get('show-web-mail-design', 'EduEmailManagementController@showWebMailDesign')->name('show-web-mail-design');
        Route::post('send-conbine-email-to-institute', 'EduEmailManagementController@sendConbineEmailToInstitute')->name('send-conbine-email-to-institute');
        Route::post('delete-web-mail-design', 'EduEmailManagementController@deleteWebMailDesign')->name('delete-web-mail-design');
    });


});

