<!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title><?php echo e($title_view); ?></title>

    <style type="text/css">

        * {
            font-family: Verdana, Arial, sans-serif;
        }
        table{
            font-size: x-small;
        }
        tfoot tr td{
            font-weight: bold;
            font-size: x-small;
        }

        .amount-right{
            text-align:right;
        }

        .gray {
            background-color: lightgray
        }

    </style>

</head>
<body>

<div>

    <?php echo $__env->make('default.site.layout.pdf-header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <table width="100%" style="margin-bottom: 10px">


        <tr>
            <td align="left"><b> Username:</b> <?php echo e($student_info['username']); ?></td>
            <td align="left"><b> Name:</b> <?php echo e($student_info['name']); ?></td>
            <td align="left"><b> Roll:</b> <?php echo e($student_info['roll']); ?></td>

        </tr>
        
        <tr>
            <td align="left"> <b>Version:</b> <?php echo e($student_info['version_name']); ?></td>
            <td align="left"> <b>Year:</b> <?php echo e($student_info['year_name']); ?></td>
            <td align="left"> <b>Shift:</b> <?php echo e($student_info['shift_name']); ?></td>
        </tr>
        <tr>
            <td align="left"><b> Class:</b> <?php echo e($student_info['class_name']); ?></td>
            <td align="left"><b> Group:</b> <?php echo e($student_info['group_name']); ?></td>
            <td align="left"> <b>Section:</b> <?php echo e($student_info['section_name']); ?></td>
        </tr>
        <tr>
            <td align="left"> <b>Type:</b> <?php echo e($student_info['type_name']); ?></td>
            <td align="left"> <b>Session:</b> <?php echo e($student_info['session_name']); ?></td>
            <td align="left"><b> Invoice No:</b> <?php echo e($payment_data['voucher_no']); ?></td>

        </tr>
        <tr>
            <td align="left"><b> Invoice Date:</b> <?php echo e($payment_data['invoice_date']); ?></td>
            <td align="left"><b> Invoice By:</b> <?php echo e($payment_data['slip_created_by']); ?></td>
            <td align="left"><b> Payment Date:</b> <?php echo e($payment_data['payment_date']); ?> </td>
        </tr>
        <tr>
            <td align="left"><b> Payment By:</b><?php echo e($payment_data['payment_created_by']); ?> </td>
            <td align="left"><b> Transaction ID:</b> <?php echo e($payment_data['transaction_id']); ?></td>
            <td align="left"></td>
        </tr>

    </table>


    <table width="100%">

        <thead style="background-color: #e2e6e9;">
        <tr>
            <th align="left">Head</th>
            <th align="left">Type</th>
            <?php if(($slip_key == 'student' && $siteInfo['show_subhead_in_payment_slip']) || $slip_key != 'student'): ?>
                <th align="left">Fee Items</th>
            <?php endif; ?>
            <th align="center" class="amount-right">Amount</th>
        </tr>
        </thead>
        <tbody>

              <?php if(!empty($payment_data['fee_allocation_details_list']) && count($payment_data['fee_allocation_details_list']) > 0): ?>
                <?php $__currentLoopData = $payment_data['fee_allocation_details_list']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index=>$item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php $__currentLoopData = $item['head_type']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $indexs=>$items): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php $__currentLoopData = $items['fee_sub_head']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $indexss => $subItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                
                                <?php if($indexs == 0 && $indexss == 0): ?>
                                    <td rowspan="<?php echo e($item['head_type_base_sub_head_count']); ?>">
                                        <?php echo e($item['name']); ?>

                                    </td>
                                <?php endif; ?>

                                
                                <?php if($indexss == 0): ?>
                                    <td rowspan="<?php echo e($items['fee_sub_head_count']); ?>">
                                        <?php echo e($items['fee_type_name']); ?>

                                    </td>
                                <?php endif; ?>

                                <?php if(($slip_key == 'student' && $siteInfo['show_subhead_in_payment_slip']) || $slip_key != 'student'): ?>
                                    <td>
                                        <?php echo e($subItem['academic_fee_sub_head']['name']); ?>

                                    </td>
                                    <td class="amount-right">
                                        <?php echo e($subItem['amount']); ?>

                                    </td>
                                <?php else: ?>
                                    <?php if($indexss == 0): ?>
                                        <td class="amount-right">
                                            <?php echo e($items['head_total_amount']); ?>

                                        </td>
                                    <?php endif; ?>
                                <?php endif; ?>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>


        <?php ($sl=1); ?>
    

        <tr style="background-color: #e2e6e9">
            <td style="padding:0px;" colspan="<?php echo e(($slip_key == 'student' && $siteInfo['show_subhead_in_payment_slip']) || $slip_key != 'student'
?2:1); ?>" class=""></td>
            <td style="padding:0px;" class="amount-right">Fee(TK)</td>
            <td style="padding:0px;" class="amount-right"><?php echo e($payment_data['fee_amount']); ?></td>
        </tr>

        

              <?php if(!empty($payment_data['waiver_allocation_details']) && count($payment_data['fee_allocation_details_list']) > 0 && $siteInfo->show_subhead_in_payment_slip): ?>
                    <?php $__currentLoopData = $payment_data['waiver_allocation_details']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index=>$item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php $__currentLoopData = $item['head_type']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $indexs=>$items): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php $__currentLoopData = $items['fee_sub_head']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $indexss => $subItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    
                                    <?php if($indexs == 0 && $indexss == 0): ?>
                                        <td rowspan="<?php echo e($item['head_type_base_sub_head_count']); ?>">
                                            <?php echo e($item['name']); ?>

                                        </td>
                                    <?php endif; ?>

                                    
                                    <?php if($indexss == 0): ?>
                                        <td rowspan="<?php echo e($items['fee_sub_head_count']); ?>">
                                            <?php echo e($items['fee_type_name']); ?>

                                        </td>
                                    <?php endif; ?>

                                    
                                    <td>
                                        <?php echo e($subItem['academic_fee_sub_head']['name']); ?>

                                    </td>

                                    
                                    <td class="amount-right">
                                        <?php echo e($subItem['percantage_status'] ? $subItem['amount']. '%' : $subItem['amount']); ?>

                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>


        <tr class="table_tr">
            <td  colspan="<?php echo e(($slip_key == 'student' && $siteInfo['show_subhead_in_payment_slip']) || $slip_key != 'student'
?2:1); ?>" class=""></td>
            <td  class="amount-right">Waiver(TK)</td>
            <td  class="amount-right"><?php echo e($payment_data['waiver_amount']); ?></td>
        </tr>
        
        <tr class="table_tr">
            <td  colspan="<?php echo e(($slip_key == 'student' && $siteInfo['show_subhead_in_payment_slip']) || $slip_key != 'student'
?2:1); ?>" class=""></td>
            <td  class="amount-right">Previous Due(TK)</td>
            <td  class="amount-right"><?php echo e($payment_data['previous_due']); ?></td>
        </tr>
        <tr class="table_tr">
            <td  colspan="<?php echo e(($slip_key == 'student' && $siteInfo['show_subhead_in_payment_slip']) || $slip_key != 'student'
?2:1); ?>" class=""></td>
            <td  class="amount-right">Extra Payment/Fine(TK)</td>
            <td  class="amount-right"><?php echo e($payment_data['fine_amount']); ?></td>
        </tr>
        <tr class="table_tr">
            <td colspan="<?php echo e(($slip_key == 'student' && $siteInfo['show_subhead_in_payment_slip']) || $slip_key != 'student'
?2:1); ?>" class="colorChange"></td>
            <td class="amount-right colorChange">Total(TK)</td>
            <td class="amount-right"><?php echo e($payment_data['total_amount']); ?></td>
        </tr>
        <?php if($payment_data['paid_by']=='cash'): ?>
        <tr class="table_tr">
            <td colspan="<?php echo e(($slip_key == 'student' && $siteInfo['show_subhead_in_payment_slip']) || $slip_key != 'student'
?2:1); ?>" class="colorChange"></td>
            <td class="amount-right colorChange">Previous Paid(TK)</td>
            <td class="amount-right"><?php echo e($payment_data['previous_paid_amount']); ?></td>
        </tr>
        <?php endif; ?>
        <tr class="table_tr">
            <td colspan="<?php echo e(($slip_key == 'student' && $siteInfo['show_subhead_in_payment_slip']) || $slip_key != 'student'
?2:1); ?>" class="colorChange"></td>
            <td class="amount-right colorChange">Transation Amount(TK)</td>
            <td class="amount-right"><?php echo e($payment_data['transaction_amount']); ?></td>
        </tr>
        <tr class="table_tr">
            <td colspan="<?php echo e(($slip_key == 'student' && $siteInfo['show_subhead_in_payment_slip']) || $slip_key != 'student'
?2:1); ?>" class="colorChange"></td>
            <td class="amount-right colorChange">Gateway Charge(TK)</td>
            <td class="amount-right"><?php echo e($payment_data['gateway_charge']); ?></td>
        </tr>
        <tr class="table_tr">

            <td colspan="<?php echo e(($slip_key == 'student' && $siteInfo['show_subhead_in_payment_slip']) || $slip_key != 'student'
?2:1); ?>"><b>In Word:</b> <?php echo e($payment_data['total_paid_amount_in_word']); ?> taka only</td>
            <td class="amount-right colorChange"><b>Payment Received (Paid TK)</b></td>
            <td class="amount-right"><b><?php echo e($payment_data['paid_amount']); ?></b></td>
        </tr>
        <tr class="table_tr">
            <td  colspan="<?php echo e(($slip_key == 'student' && $siteInfo['show_subhead_in_payment_slip']) || $slip_key != 'student'
?2:1); ?>"></td>
            <td  class="amount-right colorChange">Due(TK)</td>
            <td  class="amount-right"><?php echo e($payment_data['due_amount']); ?></td>
        </tr>

        </tbody>

    </table>
    <br><br><br>
    <table width="100%">
        <tr>
            <td align="left">
                
            </td>
            <td align="right" colspan="1">
                ------------------------<br>
                sign by authority
            </td>
        </tr>

    </table>
    <br> <br> <br>
    <table width="100%">
        <tr>
            <td>

            </td>

        </tr>
    </table>




</body>



<style>
    @page  {
        size: a4;
        margin: 1px 0;
    }
    body {
        margin: 5px 20px 0;
        border:1px dotted black;
    }
    .table_tr {
        background-color: #e2e6e9
    }

</style>
</html><?php /**PATH C:\laragon\www\EduWorldErp\resources\views/default/admin/site/student-fee/report/student-payment-voucher-pdf.blade.php ENDPATH**/ ?>