<!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title><?php echo e($title_view); ?></title>

    <style type="text/css">

        * {
            font-family: Verdana, Arial, sans-serif;
        }
        table{
            font-size: x-small;
        }
        tfoot tr td{
            font-weight: bold;
            font-size: x-small;
        }

        .amount-right{
            text-align:right;
        }

        .gray {
            background-color: lightgray
        }

    </style>

</head>
<body>

<div>

    <?php echo $__env->make('default.site.layout.pdf-header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <table width="100%">


        <tr>
            
            <td colspan="2" valign="top" align="left"><b> Name:</b> <?php echo e($payment_details['candidate_name']); ?></td>
            <td align="left"><b>Board Roll:</b> <?php echo e($payment_details['roll']); ?></td>
            <td align="left"><b>Contact Number:</b> <?php echo e($payment_details['contact_number']); ?></td>

        </tr>
        
        <tr>
            <td align="left"><b> Class:</b> <?php echo e($payment_details['class_name']); ?></td>
            <td align="left"><b> Group:</b> <?php echo e($payment_details['group_name']); ?></td>
            
        </tr>
        <tr>
            <td align="left"><b> Invoice By:</b> Admin</td>
            <td align="left"><b> Invoice Date:</b> <?php echo e($payment_details['invoice_date']); ?></td>
            <td align="left"><b> Transaction ID:</b> <?php echo e($payment_details['transaction_id']); ?></td>
            <td align="left"><b> Invoice No:</b> <?php echo e($payment_details['invoice_id']); ?></td>
        </tr>
        <tr>
            <td align="left"><b> Payment By:</b> <?php echo e($payment_details['transaction_gateway']); ?></td>
            <td align="left"><b> payment date:</b> <?php echo e($payment_details['payment_date']); ?></td>
        </tr>

    </table>


    <table width="100%">

        <thead style="background-color: #e2e6e9;">
        <tr>
            <td class=""></td>
            <th align="left">Fee Items</th>
            <th align="center" class="amount-right">Amount</th>
        </tr>
        </thead>
        <tbody>

        <?php if(($slip_owner == 'student' && $site_info->show_subhead_in_payment_slip) || $slip_owner != 'student'): ?>
            <?php $__currentLoopData = $payment_details['fee_list']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr style="height: 2px;">
                    <td class=""></td>
                    <td style="padding:0px;"><?php echo e($value['academic_fee_sub_head']); ?></td>
                    <td style="padding:0px;" class="amount-right"><?php echo e(number_format($value['amount'],2)); ?></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php else: ?>
            <tr style="height: 2px;">
                <td class=""></td>
                <td style="padding:0px;">Admission Fee</td>
                <td style="padding:0px;" class="amount-right"><?php echo e(number_format($payment_details['total_paid_amount'],2)); ?></td>
            </tr>
        <?php endif; ?>

        
        
 
        <tr class="table_tr">
            <td class=""></td>
            <td class="amount-right">Extra Payment/Fine(TK)</td>
            <td class="amount-right"><?php echo e(number_format($payment_details['extra_fine'], 2)); ?></td>
        </tr> 
        <tr class="table_tr">
            <td class="colorChange"></td>
            <td class="amount-right colorChange">Total(TK)</td>
            <td class="amount-right"><?php echo e(number_format($payment_details['total_paid_amount'],2)); ?></td>
        </tr>
    
        <tr class="table_tr">
            <td class="colorChange"></td>
            <td class="amount-right colorChange">Transation Amount(TK)</td>
            <td class="amount-right"><?php echo e(number_format($payment_details['transaction_amount'],2)); ?></td>
        </tr>
        <tr class="table_tr">
            <td class="colorChange"></td>
            <td class="amount-right colorChange">Gateway charge(TK)</td>
            <td class="amount-right"><?php echo e(number_format($payment_details['gateway_charge'],2)); ?></td>
        </tr>
        <tr class="table_tr">
            <td><b>In Word:</b> <?php echo e($payment_details['total_paid_amount_in_word']); ?> taka only</td>
            <td class="amount-right colorChange"><b>Payment received (Paid TK)</b></td>
            <td class="amount-right"><b><?php echo e(number_format($payment_details['total_paid_amount'],2)); ?></b></td>
        </tr>
        </tbody>

    </table>
    <br><br><br>
    <table width="100%">
        <tr>
            <td align="left">
                
            </td>
            <td align="right" colspan="1">
                ------------------------<br>
                sign by authority
            </td>
        </tr>

    </table>
    <br> <br> <br>
    <table width="100%">
        <tr>
            <td>

            </td>

        </tr>
    </table>




</body>



<style>
    @page  {
        size: a4;
        margin: 1px 0;
    }
    body {
        margin: 5px 20px 0;
        border:1px dotted black;
    }
    .table_tr {
        background-color: #e2e6e9
    }

</style>
</html><?php /**PATH C:\laragon\www\EduWorldErp\resources\views/default/site/student_admission/admission-payment-slip.blade.php ENDPATH**/ ?>