<!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title><?php echo e($report_tittle); ?></title>

    <style type="text/css">
        * {
            font-family: Verdana, Arial, sans-serif;
        }

        table {
            font-size: x-small;
        }

        tfoot tr td {
            font-weight: bold;
            font-size: x-small;
        }

        .gray {
            background-color: lightgray
        }

        @page  {
            size: 21cm 29.7cm;
            margin: 15px;

        }

        body {
            border: 1px dotted black;
            padding: 2px;
            border-radius: 5px;

        }
    </style>

</head>
<body>

<table width="100%">
    <tr>
        <td valign="top">
            
            <img src="<?php echo e(asset('image/named-logo.jpg')); ?>" width="120" height="20">

        </td>
        <td align="right">
            <address>
                <strong>Edu world</strong>
                <br/>info@eduworld.com.bd
                <br/>+88 01901-029440
            </address>

        </td>
    </tr>

</table>

<table width="100%">
    <tr>

        <td>

            Bill To
            <address>
                <strong><?php echo e($the_invoice->siteInfo->site_name ?? 'N/A'); ?></strong>
                <br/>
                <strong><?php echo e($the_invoice->siteInfo->address ?? 'N/A'); ?></strong>
                <br>
                <?php echo e($the_invoice->siteInfo->site_phone); ?>

            </address>
        </td>
        <td style=" font-size: 12px; text-align: right; vertical-align: bottom;">

            <strong>Invoice no.:</strong><?php echo e($the_invoice->invoice_no); ?>

            <br>
            <strong>Invoice Date: </strong><?php echo e(date('d F Y',strtotime($the_invoice->invoice_date))); ?>

            <br>
            <strong>Due Date: </strong><?php echo e(date('d F Y',strtotime($the_invoice->due_date))); ?>

            <br>
            <strong>Payment Date: </strong>
            <?php if(count($the_invoice->payments)): ?>
                <?php echo e(date('d F Y',strtotime($the_invoice->payments->last()->payment_date ??  ''))); ?>


            <?php else: ?>
                <span style="color:red;"> Due Invoice</span>
            <?php endif; ?>
        </td>
    </tr>


    <tr>
        <td></td>
        <td style=" font-size: 12px; text-align: right; vertical-align: bottom;">
            <b>Printed At:</b> <?php echo e(date('d-m-Y h:i:s A',time())); ?>

        </td>
    </tr>

</table>

<br/>

<table width="100%">
    <thead style="background-color: lightgray;">
    <tr>
        <th>#</th>
        <th>Particulars</th>
        <th>Month For</th>
        <th align="right">Unit Price</th>
        <th align="right">Quantity</th>
        <th align="right"> Tax</th>
        <th align="right"> Price</th>
    </tr>
    </thead>
    <tbody>

    <?php if(count($the_invoice->details)>0): ?>
        <?php ($total=0 ); ?>
        <?php ($paid_total=0 ); ?>

        <?php $__currentLoopData = $the_invoice->details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k=>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <th scope="row"><?php echo e($k+1); ?></th>
                <td><?php echo e($value->item->item_name); ?></td>
                <td>
                    <?php if($value->month): ?>
                        <?php echo e($value->month->name ?? ''); ?>    <?php echo e(date('Y',strtotime($the_invoice->invoice_date))); ?>

                    <?php endif; ?>
                </td>
                <td align="right"><?php echo e($value->item_price); ?></td>
                <td align="right"><?php echo e($value->item_quantity); ?></td>
                <td align="right">
                    <?php if($value->tax_percentage): ?>
                        ( <?php echo e($value->tax_percentage); ?> %)
                    <?php endif; ?>

                    <?php echo e($value->total_tax); ?>

                </td>
                <td align="right">
                    <?php echo e($value->item_final_amount); ?>

                </td>
            </tr>
            <?php echo e($total =( $total + ($value->piece_price * $value->piece))); ?>

            <?php echo e($paid_total =( $paid_total + ($value->paid_amount))); ?>




        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>
    </tbody>

    <tfoot>
    <tr>
        <td colspan="5"></td>
        <td align="right">Subtotal</td>
        <td align="right"> <?php echo e(number_format($the_invoice->sub_total,2)); ?></td>
    </tr>

    <tr>
        <td colspan="5"></td>
        <td align="right">Tax
            <?php if($the_invoice->tax_percentage): ?>
                ( <?php echo e($the_invoice->tax_percentage); ?> %)
            <?php endif; ?>
        </td>
        <td align="right">(+) <?php echo e(number_format($the_invoice->total_tax,2)); ?></td>
    </tr>

    <tr>
        <td colspan="5"></td>
        <td align="right">Previous Due</td>
        <td align="right">(+) <?php echo e(number_format($the_invoice->previous_due,2)); ?></td>
    </tr>

    <tr>
        <td colspan="5"><b>Note: </b><i><?php echo e($the_invoice->note); ?></i></td>
        <td align="right">Discount</td>
        <td align="right">(-) <?php echo e(number_format($the_invoice->discount_amount,2)); ?></td>
    </tr>


    <tr>
        <td colspan="5"></td>
        <td align="right">Total Paid</td>
        <td align="right"><?php echo e(number_format(($the_invoice->amount_paid),2)); ?></td>
    </tr>
    -
    <tr>
        <td colspan="5"></td>
        <td align="right">Due</td>
        <td align="right" class="gray"><?php echo e(number_format($the_invoice->amount_due,2)); ?></td>
    </tr>

    <tr>
        <td colspan="4">In word :

            <?php if($the_invoice->amount_due): ?>
                <?php echo e(ucwords( convertNumberToWord($the_invoice->amount_due))); ?>

            <?php else: ?>
                <?php echo e(ucwords( convertNumberToWord($the_invoice->amount_paid))); ?>

            <?php endif; ?>
             Only
        </td>
        <td colspan="3"></td>
    </tr>

    <tr>
        <td style="color: #2d6987; font-size: 10px" colspan="3">N.B. computer generated document, no signature
            required
        </td>

        <td colspan="4" style="color: #0a0302; font-size: 10px" >

            Please Pay Through
            <br>
            ----------------------------   <br>
            Acc. Name: THE WORLD
            <br>
            A/C. 02 10209553 001
            <br>
            IFIC Bank, Khulshi Branch, Chattogram
        </td>
    </tr>
    </tfoot>
</table>

</body>
</html>
<?php /**PATH C:\laragon\www\EduWorldErp\resources\views/default/admin/edu/site-payment/payment-report.blade.php ENDPATH**/ ?>