<!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title><?php echo e($title_view); ?></title>

    <style type="text/css">

        * {
            font-family: Verdana, Arial, sans-serif;
        }
        table{
            font-size: x-small;
        }
        tfoot tr td{
            font-weight: bold;
            font-size: x-small;
        }

        .amount-right{
            text-align:right;
        }

        .gray {
            background-color: lightgray
        }

        .slot-table td {
            border: 1px solid #999999;
            border-width: thin;
            border-spacing: 2px;
            /*border-style: none;*/

        }

        .heading-slot-bg {
            background-color: #dcdcdc;
            color: #000000;
            text-align: center;
            width: 25px;
            vertical-align: middle;
            padding-left: 20px;
        }

        .slot {
            width: 100px;
            min-height: 200px;
            padding: 0 3px;
        }

    </style>

</head>
<body>
<?php echo $__env->make('default.site.layout.pdf-header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


<table width="100%">
    <tr>
        <td align="left"> <b>Shift:</b> <?php echo e($class_shift_details->shift_name ?? ""); ?></td>
        <?php if(count($class_list)): ?>
            <td align="left" > <b>Class:</b> 
                <?php $__currentLoopData = $class_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $class): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php echo e($class->class_name); ?>,
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </td>
        <?php endif; ?>
        <?php if(count($class_group_list)): ?>
            <td align="left"> <b>Class Group:</b> 
                <?php $__currentLoopData = $class_group_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php echo e($group->group_name); ?>,
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </td>
        <?php endif; ?>
        <?php if(count($section_list)): ?>
            <td align="left"> <b>Section:</b> 
                <?php $__currentLoopData = $section_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $section): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php echo e($section->section_name); ?>,
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </td>
        <?php endif; ?>
        <td align="left"><b> From Date:</b> <?php echo e($from_date ?? ""); ?></td>
        <td align="left"><b> To Date:</b> <?php echo e($to_date ?? ""); ?></td>
    </tr>

</table>

<table class="slot-table" width="100%" cellspacing="0" border="0">
    <thead style="background-color:  #e6e6e6;">
    <tr>
        <td  style="text-align:center; padding:2px; border: 1px solid black;"><b>Serial</b></td>
        <td  style="padding:2px; border: 1px solid black;"><b>Student</b></td>
        <td  style="padding:2px; border: 1px solid black; text-align:center"><b>Roll</b></td>
        <td  style="padding:2px; border: 1px solid black; text-align:center"><b>Class</b></td>
        <?php if($class_group_present): ?>
            <td  style="padding:2px; border: 1px solid black; text-align:center"><b>Group</b></td>
        <?php endif; ?>
        <?php if($section_present): ?>
            <td  style="padding:2px; border: 1px solid black; text-align:center"><b>Section</b></td>
        <?php endif; ?>
        <?php if($session_present): ?>
            <td  style="padding:2px; border: 1px solid black; text-align:center"><b>Session</b></td>
        <?php endif; ?>
        <?php $__currentLoopData = $subHeadList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subhead): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td  style="padding:2px; border: 1px solid black;" class="amount-right"><b><?php echo e($subhead['name']); ?></b></td>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <td  style="padding:2px; border: 1px solid black;" class="amount-right"><b>Fine</b></td>
        <td  style="padding:2px; border: 1px solid black;" class="amount-right"><b>Total Amount</b></td>
 
    </tr>
    </thead>
    <tbody>


    <?php ($sl=1); ?>
    <?php $__currentLoopData = $paymentList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

        <tr>
            <td style="text-align:center; padding:2px; border: 1px solid black;"><?php echo e($key+1); ?></td>
            <td style="padding:2px; border: 1px solid black;"><?php echo e($item['student_history']['full_name_username']); ?></td>
            <td style="padding:2px; border: 1px solid black; text-align:center"><?php echo e($item['student_history']['student_full_roll_number']); ?></td>
            <td style="padding:2px; border: 1px solid black; text-align:center"><?php echo e($item['student_history']['st_class']?$item['student_history']['st_class']['class_name']:''); ?></td>
           
            <?php if($class_group_present): ?>
                <td style="padding:2px; border: 1px solid black; text-align:center"><?php echo e($item['student_history']['acc_group']?$item['student_history']['acc_group']['group_name']:''); ?></td>
            <?php endif; ?>
            <?php if($section_present): ?>
                <td style="padding:2px; border: 1px solid black; text-align:center"><?php echo e($item['student_history']['section']?$item['student_history']['section']['section_name']:''); ?></td>
            <?php endif; ?>
            <?php if($session_present): ?>
                <td style="padding:2px; border: 1px solid black; text-align:center"><?php echo e($item['student_history']['session']?$item['student_history']['session']['session_name']:''); ?></td>
            <?php endif; ?>

            
           
            <?php $__currentLoopData = $subHeadList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subHead): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php $__currentLoopData = $item['sub_head_list']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sub_heade_item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if($subHead['id']==$sub_heade_item['sub_head_id']): ?>
                        <td class="amount-right" style="padding:2px; border: 1px solid black;"><?php echo e(number_format($sub_heade_item['total_pay_amount'],2)); ?></td>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
             
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <td class="amount-right" style="padding:2px; border: 1px solid black;"><?php echo e(number_format($item['fine_amount'],2)); ?></td>
            <td class="amount-right" style="padding:2px; border: 1px solid black;"><?php echo e(number_format($item['sub_total_pay_amount'],2)); ?></td>

            
        </tr>

    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


    </tbody>
    <tfoot  style="background-color:  #e6e6e6;">
    <tr>
        <td colspan="<?php echo e(4+($class_group_present?1:0)+($section_present?1:0)+($session_present?1:0)); ?>" class="amount-right" style="border: 1px solid black;">Total</td>
        <?php $__currentLoopData = $grossReport['subhead_total_array']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subhead_total): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td class="amount-right" style="border: 1px solid black;"><?php echo e(number_format($subhead_total['subhead_total'],2)); ?></td>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <td class="amount-right" style="border: 1px solid black;"><?php echo e(number_format($grossReport['total_fine_amount'],2)); ?></td>
        <td class="amount-right" style="border: 1px solid black;"><?php echo e(number_format($grossReport['total_pay_amount'],2)); ?></td>
        

    </tr>
    </tfoot>

</table>

</body>



<style>
   @page  {
    size: A4 landscape; /* Set to A4 landscape */
    margin: 1px 0;
    }

    body {
        margin: 5px 20px 0;
        /* border: 1px dotted black; */
    }

</style>
</html><?php /**PATH C:\laragon\www\EduWorldErp\resources\views/default/admin/site/student-fee/report/sub-head-wise-payment-report-pdf.blade.php ENDPATH**/ ?>