<!DOCTYPE html>
<html>

<head>
    @php($site = getSiteInfoForPdf())
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>


    <title>{{ $page_tittle }}</title>

    <style>
        @font-face {
            font-family: 'Verdana';
            font-weight: 100;
            font-style: normal;
            font-variant: normal;
            src: url("{{ public_path() }}/fonts/Verdana.ttf") format("truetype");
        }

        body {
            font-family: "Verdana", sans-serif;
            font-size: 12px;
        }

        .st-image {
            text-align: center;
            width: 80px;
            height: 80px;
            padding-top: 40px;

            /* Fully rounded corners */
            /* border-top-left-radius: 40px;
            border-top-right-radius: 40px;
            border-bottom-left-radius: 40px;
            border-bottom-right-radius: 40px; */
        }


        .data-table th {
            font-size: 9px;
            text-align: left;
            line-height: 100%;
        }

        .data-table td {
            font-size: 9px;
            text-align: left;
            line-height: 120%;
        }

        .page-break {
            page-break-after: always;
        }

        .main-div {

            background-position: center;
            background-size: cover;
            background-repeat: no-repeat;
            border: .5px solid black;

            width: 208px;
            padding-top: 1px;
            padding: 2px 6px;
            height: 346px;
            margin: 0 0 0 0;
            border-radius: 5px;
            float: left;
            overflow: hidden;

        }

        .site-logo {
            background: white;
            border-top-left-radius: 6px/51px;
            border-top-right-radius: 6px/51px;
            border-bottom-left-radius: 6px/51px;
            border-bottom-right-radius: 6px/51px;
            height: 38px;
            margin-top: 3px;
        }
    </style>

</head>

<body>

    {{--
@include('default.site.layout.pdf-header')


--}}


    @foreach ($card_data as $key => $value)
        {{--
        <div class="bg-image"
             style="width:199px; padding: 2px 6px; height:326px; margin:0 10px 10px 20px; border-radius: 0px;float: left; overflow: hidden">
    --}}

        <div class="main-div" style="background-image: url({{ public_path($bg_path) }});">
            <table cellspacing="0" border="0" width="100%;">

                <tbody>
                    <tr>
                        <td style="width: 100%;text-align: center; padding: 5px">
                    </tr>


                </tbody>
            </table>
            <table cellspacing="0" border="0" width="100%;">

                <tbody
                    style="font-size: 11px; text-align:center; color: white; text-transform:capitalize;font-weight: bold">
                    {{-- <tr style="">
                        <td style="width: 100%">
                            <div style="margin-left: 10px;margin-top: -12px">
                                <img class="site-logo" style="" src="{!! public_path($site_logo_path) !!}">
                            </div>
                            <div style="margin-left: 90px;margin-top: -68px;">
                                <p style="font-size:{{$institute_name_font_size}}; color:white;text-align:center; text-transform:capitalize;font-weight: bold ;  margin:0px ">
                                    Chattogram Collegiate School </p>
                                <p style="font-size: 20px;margin:0px;text-align: center ">Pologround, Kotwali, Chattogram</p>
                            </div>


                        </td>
                    </tr> --}}
                    <tr style="">
                        <td style="width: 100%">
                            <div style="margin-left: 10px;margin-top: -12px">
                                <!--<img class="site-logo" style="" src="{!! public_path($site_logo_path) !!}">-->
                            </div>
                            <div style="margin-left: 0;margin-top: -100px; color:white;text-align:center;">
                                <img class="site-logo" style="" src="{!! public_path($site_logo_path) !!}">
                                <p
                                    style="font-size:{{ $institute_name_font_size }}; text-transform:capitalize;padding-left: px;font-weight: bold ; margin:0px; ">
                                    Chattogram Collegiate School</p>

                            </div>


                        </td>
                    </tr>
                    {{-- <tr>
                        <td style="width: 100%;text-align: center; padding-top: 2px">
                    </tr>
                    <tr style="width: 100%;text-align: center">


                        <td>
                            <span
                                style="font-size: 12px;text-align: left; text-transform:capitalize;font-weight: bold">{{ $value['site_name'] ?? '--' }}</span>
                        </td>

                    </tr>
                    <tr>


                        <td>
                            <span
                                style="font-size: 10px;text-align: left; text-transform:capitalize;font-weight: bold">Doublemooring,
                                Chattogram</span>
                        </td>
                    </tr> --}}

                </tbody>
            </table>


            <table cellspacing="0" border="0" width="100%;">

                <tbody>

                    <tr>
                        <td style="width: 100%;text-align: center">

                            @if (file_exists(public_path($value['latest_photo_path'])))
                                <img class="st-image"src="{{ public_path($value['latest_photo_path']) }}">
                            @else
                                <img class="st-image" src="{{ public_path('uploads') . '/image-not.png' }}">
                            @endif

                        </td>
                    </tr>
                    <tr>
                        <td style="width: 100%;text-align: center; padding-top:10px">
                            <span style="text-transform:uppercase;font-size: 11px; font-weight: bold; color: #2E62AE">
                                {{ $value['full_name'] ?? '--' }} </span>
                        </td>
                    </tr>
                    <tr>
                        <td style="text-align: center">
                            <b>  {{ $value['designation_name'] }} </b>
                            <br>
                               @if($value['subject'])
                                 <b style="color:black">({{ $value['subject'] }})</b>
                                   @endif

                        </td>
                    </tr>
                </tbody>
            </table>
            <div style="margin: 10px 20px 20px 20px">
                <table class="data-table" cellspacing="0" border="0" width="100%;" style="">

                    <tbody>
                        <tr>
                            <th style="width: 30%;">
                                <nobr> PDS ID </nobr>
                            </th>
                            <td style="width: 70%;">
                                : {{ $value['employee_index_number'] ?? '--' }}
                            </td>
                        </tr>

                        <tr>
                            <th style="width: 30%;">
                                <nobr> Mobile No. </nobr>
                            </th>
                            <td style="width: 70%;">
                                : {{ $value['contact_number'] ?? '--' }}
                            </td>
                        </tr>


                        </td>
                        </tr>


                    </tbody>
                </table>
                <table class="data-table" cellspacing="0" border="0" width="100%;" style="">
                    <tr>
                        <th colspan="3"></th>
                    </tr>
                    <tr>
                        <td style="width: 100%;text-align: center; padding: 20px">

                        </td>
                    </tr>
                    <tr>
                        <td colspan="2" style="text-align:left; padding-right:15px;">
                            <div style="position: absolute;top:-16px;margin-left: 10px">
                                <img width="80" src="{{ public_path($signature) }}"
                                    style="position: absolute;top:12px;left: -10px">
                                <br><br>
                                <span
                                    style="border-top: 1px dotted black; font-weight:bold padding: 0 10px; font-size:8px">{{ $designation }}</span>
                            </div>
                        </td>

                        {{-- <td style="width: 100%; " style="">
                            @if ($showQRCode)
                                <img width="120" style="position: absolute;margin-left: 60px;margin-top: -50px"
                                    src="data:image/png;base64, {!! base64_encode(
                                        QrCode::size(48)->generate(
                                            $domain . '/site-public/student-details/' . $value['username'] . '.' . $site_id . '.' . $value['history_id'],
                                        ),
                                    ) !!} ">
                            @endif

                        </td> --}}
                    </tr>

                </table>
            </div>

        </div>


        @if (($key + 1) % 3 == 0)
            <div style="clear:both;"></div>
        @endif


        @if (($key + 1) % 9 == 0)
            <div class="page-break"></div>
        @endif
    @endforeach


</body>


<style>
    @page {
        size: a4;
        margin: 0;

    }

    body {
        margin: 10px 35px 3px;
        background-color: #ffffff;
    }
</style>

</html>
